\name{datasets}
\docType{data}

\alias{datasets}

\alias{autism_data}
\alias{autism_data_large}
\alias{restingstate_data}
\alias{fruitfly_data}
\alias{symptom_data}
\alias{Fried2015}
\alias{PTSD_data}
\alias{mgm_data}
\alias{mvar_data}
\alias{modnw}
\alias{B5MS}
\alias{msq_p5}
\alias{msq_p3}
\alias{dataGD}


\title{Example Datasets in the mgm Package}
\description{
The autism dataset (and its short version) are taken from Deserno et al. (2016).

The restingstate fMRI data are taken from Schmittmann et al. (2015).

The gene expression data across the life span of the fruit fly are taken from Gibberd & Nelson (2017), who took a subset of the data first presented by Arbeitman et al. (2002).

The symptom data of the single individual diagnosed with major depression is described in Kossakowski et al. (2017).

The PTSD data is taken from McNally et al. (2015).

The dataset \code{mgm_data} is generated by example code shown in ?mgmsampler, and \code{mvar_data} is generated by example code shown in ?mvarsampler.

The dataset \code{Fried2015} contains 515 cases of the 11 depression symptoms measured by the CES-D and is taken from Fried et al. 2015.

The dataset \code{B5MS} contains the mean scores across subscales (48 items each) for the Big Five personality traits. The dataset is taken from the \code{qgraph} package (Epskamp, et al., 2012) and was first used in Dolan et al. (2009).

The dataset \code{dataGD} contains 4 continuous variables and 3 categorical variables that are generated from a mixed DAG. This dataset is useful to illustrate estimating group differences in MGMs using moderation.

All datasets are loaded automatically. All real data sets come as a list including the data and additional information (names of variables, types of variables, time stamps for time series data, etc.)

}


\references{

Deserno, M. K., Borsboom, D., Begeer, S., & Geurts, H. M. (2016). Multicausal systems ask for multicausal approaches: A network perspective on subjective well-being in individuals with autism spectrum disorder. Autism.

Dolan, C. V., Oort, F. J., Stoel, R. D., & Wicherts, J. M. (2009). Testing measurement invariance in the target rotated multigroup exploratory factor model. Structural Equation Modeling, 16(2), 295-314.

Epskamp, S., Cramer, A. O., Waldorp, L. J., Schmittmann, V. D., & Borsboom, D. (2012). qgraph: Network visualizations of relationships in psychometric data. Journal of Statistical Software, 48(4), 1-18.

Schmittmann, V. D., Jahfari, S., Borsboom, D., Savi, A. O., & Waldorp, L. J. (2015). Making large-scale networks from fMRI data. PloS one, 10(9), e0129074.

Gibberd, A. J., & Nelson, J. D. (2017). Regularized Estimation of Piecewise Constant Gaussian Graphical Models: The Group-Fused Graphical Lasso. Journal of Computational and Graphical Statistics, (just-accepted).

Arbeitman, M. N., Furlong, E. E., Imam, F., Johnson, E., Null, B. H., Baker, B. S., ... & White, K. P. (2002). Gene expression during the life cycle of Drosophila melanogaster. Science, 297(5590), 2270-2275.

Kossakowski, J., Groot, P., Haslbeck, J., Borsboom, D., & Whichers, M. (2017). Data from "Critical Slowing Down as a Personalized Early Warning Signal for Depression". Journal of Open Psychology Data, 5(1).

McNally, R. J., Robinaugh, D. J., Wu, G. W., Wang, L., Deserno, M. K., & Borsboom, D. (2015). Mental disorders as causal systems a network approach to posttraumatic stress disorder. Clinical Psychological Science, 3(6), 836-849.

Fried, E. I., Bockting, C., Arjadi, R., Borsboom, D., Amshoff, M., Cramer, A. O., ... & Stroebe, M. (2015). From loss to loneliness: The relationship between bereavement and depressive symptoms. Journal of abnormal psychology, 124(2), 256.

}

\keyword{datasets}

