% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSnps_function.R
\name{makeSnps}
\alias{makeSnps}
\title{Make SNP list}
\usage{
makeSnps(mgl, saveFile = FALSE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{saveFile}{A logical flag indicating whether a csv file ('Snps.csv') should be saved in the current directory.}
}
\description{
\code{makeSnps} returns a list with four elements summarizing the SNPs associated with each gene via GWAS results, eQTL databases, etc.  The first element (snpRes) is a list with length corresponding to the number of candidate genes and includes all associated SNPs split by source.  The second element (snpList) collpases the first so only SNPs for each gene are listed, regardless of the source.  The third element (snpTable) is a dataframe with two columns: SNPs and gene names.  The fourth element (snpCount) is a table with the number of elements corresponding to the number of unique SNPs in the genelist - reported for each SNP is the number of times it appears.  It is sorted in descending order.  The structure is similar to the \code{\link{makeGo}} and \code{\link{makePhenotypes}} functions.
}
\details{
This gives a summary of all SNPs associated with the gene.  Based on all elements in the list containing SNP information: eqtl (element 14), sqtlSeek (element 15), sqtlAltrans (element 16), pqtl (element 17), dnase (element 21), gwasCatalog (element 18), grasp (element 19).
}
\examples{
exMgl() -> myMgl
myMgl <- makeSnps(myMgl, saveFile = FALSE) -> mySnps

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSummary}}
}

