% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeOverlapTable_function.R
\name{makeOverlapTable}
\alias{makeOverlapTable}
\title{Returns information for SNPs that appear in two user-defined groups for a given gene}
\usage{
makeOverlapTable(mgl, overlap, saveFile = TRUE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{overlap}{A list of overlapping snps made using \code{\link{makeOverlap}}}

\item{saveFile}{A logical flag indicating whether a csv ('Overlap[groups].csv') should be saved in the current directory}
}
\description{
\code{makeSummary} returns a nested list with a dataframe for each gene, snp, source combination (i.e. myOverlapTable[[gene]][[snp]][[source]]).
}
\details{
For every gene with SNPs that overlap between two different user defined groups (see \code{\link{makeOverlap}}), provides a list of dataframes for each overlapping SNP that details the association whether it be eQTL, splicing, or trait-based.  Provides the details for overlapping SNPs.
}
\examples{
exMgl() -> myMgl
makeOverlap(myMgl, snpsA = c('cisEqtls'), snpsB = c('gwasCatalog'), saveFile = TRUE) -> myOverlap
makeOverlapTable(myMgl, myOverlap, saveFile = TRUE) -> myOverlapTable

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

