% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvrggd.R
\name{mvrggd}
\alias{mvrggd}
\title{Simulate from a Multivariate Generalized Gaussian Distribution}
\usage{
mvrggd(n = 1 , mu, Sigma, beta, tol = 1e-6)
}
\arguments{
\item{n}{integer. Number of observations.}

\item{mu}{length \eqn{p} numeric vector. The mean vector.}

\item{Sigma}{symmetric, positive-definite square matrix of order \eqn{p}. The dispersion matrix.}

\item{beta}{positive real number. The shape of the distribution.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma.}
}
\value{
A matrix with \eqn{p} columns and \code{n} rows.
}
\description{
Produces one or more samples from a multivariate (\eqn{p} variables) generalized Gaussian distribution (MGGD).
}
\details{
A sample from a centered MGGD with dispersion matrix \eqn{\Sigma}
and shape parameter \eqn{\beta} can be generated using:

\eqn{X = \tau \Sigma^{1/2} u}

where \eqn{u} is a random vector uniformly distributed on the unit sphere and
\eqn{\tau} is such that \eqn{\tau^{2\beta}} is generated from a distribution
\eqn{\Gamma(\frac{p}{2\beta}, 2)}.

This property is used to generate a sample from a MGGD.
}
\examples{
mu <- c(0, 0, 0)
Sigma <- matrix(c(0.8, 0.3, 0.2, 0.3, 0.2, 0.1, 0.2, 0.1, 0.2), nrow = 3)
beta <- 0.74
mvrggd(100, mu, Sigma, beta)

}
\references{
E. Gomez, M. Gomez-Villegas, H. Marin. A Multivariate Generalization of the Power Exponential Family of Distribution.
Commun. Statist. 1998, Theory Methods, col. 27, no. 23, p 589-600.
\doi{10.1080/03610929808832115}
}
\seealso{
\code{\link{mvdggd}}: probability density of a MGGD..

\code{\link{estparmvggd}}: estimation of the parameters of a MGGD.
}
\author{
Nizar Bouhlel, Pierre Santagostini
}
