% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_gam.R
\name{simulate.gam}
\alias{simulate.gam}
\title{Simulating responses from a GAM object}
\usage{
\method{simulate}{gam}(object, nsim = 1, seed = NULL, method = "auto",
  u = NULL, ...)
}
\arguments{
\item{object}{the output of a \code{gam()} or \code{bam()} call.}

\item{nsim}{the number of simulated vectors of responses. A positive integer.}

\item{seed}{currently not used.}

\item{method}{the method used for the simulation. If set to "rd" then \code{o$family$rd()}
will be used, if available. If set to "qf" then \code{o$family$qf()} (which is
the inverse cdf of the response distribution) will be used to transform some
uniform variates.}

\item{u}{a matrix where each row is a vector of uniform random variables in (0, 1).
This will be used to simulate responses only if \code{method = "qf"}.}

\item{...}{currently not used.}
}
\value{
A matrix where each row is a vector of simulated responses. The number of columns
is equal to the number of responses in the fitted object.
}
\description{
This method can be used to simulate vectors of responses from a gamObject.
}
\examples{
library(mgcViz)

set.seed(2) ## simulate some data... 
dat <- gamSim(1,n=400,dist="normal",scale=2)
b <- gam(y~s(x0)+s(x1)+s(x2)+s(x3),data=dat)

# Simulate three vectors of responses
matplot(t(simulate(b, nsim = 3)), pch = 19, col = c(1, 3, 4)) 

}
