\name{phase1}
\alias{phase1}
\title{ Function to simulate estimation uncertainty.}
\description{ Simulating the effects of the estimation uncertainty.}

\details{The changed demands are generated by the interval between [o+a,o+b], where o is the original value. The random generator can follow uniform (=default), or beta distribution.}

\usage{
phase1(x,a=-0.1,b=0.30,pdftype="uniform")}

\arguments{
  \item{x}{is either a Project Domain Matrix (a numeric matrix), where PDM=[LD,TD, CD, {QD,RD}]. LD is an N by N upper triangular matrix of logic domain (a numeric matrix); TD is an N by w matrix of task durations (a numeric matrix); CD is an N by w matrix of cost demands (a numeric matrix); QD is an optinal N by w matrix of quality parameters (a numeric optional matrix); RD is an N by w*nR matrix of resource demands (a numeric optional matrix), or PDM list, which contain a PDM matrix, and the number of completion modes (w) and the number of resources.}
   \item{a}{ optimistic duration, the negative percent deviation from the actual duration (a negative value). The default value is a=-0.1, which means if the actual duration is 1, the minimal possible duration is 0.9.}
   \item{b}{ pessimistic duration, the positive percent deviation from the actual duration (a positive value). The default value is b=0.3, which means if the actual duration is 1, the maximal possible duration is 1.3.}
   \item{pdftype}{ the pdftype is either 'uniform' or 'beta' (the default value is 'uniform'), which means the generated distribution either follows uniform or a beta distribution betweem interval [a,b]}
}

\value{
 \item{PDMout}{PDM matrix with same structure as the input PDM matrix (a matrix).}
}
\references{
Kosztyán, Z. T. (2022). MFPP: Matrix-based flexible project planning. SoftwareX, 17, 100973.
}
\author{ Zsolt T. Kosztyan*, Aamir Saghir

e-mail: kzst@gtk.uni-pannon.hu}

\seealso{\code{\link{tpc}}, \code{\link{tpq}}, \code{\link{tpt}}, \code{\link{tpr}},\code{\link{maxscore_PEM}},\code{\link{phase2}},\code{\link{phase3}}, \code{\link{generatepdm}}.}
\examples{

# Simulation of project domain matrix based on customer claims
# of a project scenario using MFPP package.

# Generate a project domain matrix based on
# logic domain, task duration, cost demans,
# quality parameters (optional),  resource demand (optional) of a project.

PDM=generatepdm(30,0.05,0,20,30,20,2,2,2,QD=TRUE,lst=TRUE)
PDM

# Define negative percentage deviation from actual duration.
a=-0.20

# Define negative percentage deviation from actual duration.
b=0.40

# Simulate the effects of estimation uncertainty of a project scenario using MFPP package
# with default values.
 Res<-phase1(PDM)
 summary(Res)

# Simulate the estimation uncertainty of customer claims of a project scenario using MFPP package
# with specified values.
 Res<-phase1(PDM$PDM,a,b,"beta")
 summary(Res,w=2,Rs=2)
}
\concept{project planning}
