% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builders.R
\name{build_M_Lambda}
\alias{build_M_Lambda}
\title{Build the \eqn{M_t\Lambda} matrices}
\usage{
build_M_Lambda(Y, Lambda, n_vars, n_lags, n_T)
}
\arguments{
\item{Y}{The data matrix of size \code{(n_T + n_lags) * n_vars} with \code{NA} representing missingness. All monthly variables must be placed before quarterly variables.}

\item{Lambda}{The Lambda matrix (size \code{n_vars* (n_vars*n_lags)}).}

\item{n_vars}{The number of variables.}

\item{n_lags}{The number of lags.}

\item{n_T}{The number of time points.}
}
\value{
\item{M_Lambda}{A list of length \code{n_T}.}
}
\description{
Builds the selection matrices \eqn{M_t\Lambda}.
}
\details{
The element \code{M_Lambda[[t]]} corresponds to \eqn{M_t\Lambda}. Currently, if element \code{i} of \code{Y[t, ]} is \code{NA}, then row \code{i} of \code{M_Lambda[[t]]} is all \code{NA}.
}
\keyword{internal}
