% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{eval_Pi_Sigma_RaoBlack}
\alias{eval_Pi_Sigma_RaoBlack}
\title{Evaluate the conditional posterior of Pi and Sigma using Rao-Blackwellization}
\usage{
eval_Pi_Sigma_RaoBlack(Z_array, d, post_psi_center, post_Pi_center,
  post_Sigma_center, post_nu, prior_Pi_mean, prior_Pi_Omega, prior_S,
  n_vars, n_lags, n_reps)
}
\arguments{
\item{Z_array}{The array of draws of Z from the Gibbs sampler.}

\item{d}{The matrix of size \code{(n_T + n_lags) * n_determ} of deterministic terms.}

\item{post_psi_center}{The value at which to do the evaluation (e.g. the posterior mean/median).}

\item{post_Pi_center}{The value at which to do the evaluation (e.g. the posterior mean/median).}

\item{post_Sigma_center}{The value at which to do the evaluation (e.g. the posterior mean/median).}

\item{post_nu}{The posterior of the parameter \eqn{\nu}.}

\item{prior_Pi_Omega}{Matrix of size \code{(n_vars*n_lags)* (n_vars*n_lags)} containing the prior for (part of) the prior covariance of the dynamic coefficients.}

\item{prior_S}{The prior for \eqn{\Sigma}.}

\item{n_vars}{The number of variables.}

\item{n_lags}{The number of lags.}

\item{n_reps}{The number of replications.}

\item{prior_Pi}{Matrix of size \code{n_vars * (n_vars*n_lags)} containing the prior for the mean of the dynamic coefficients.}
}
\value{
The return is:
\item{evals}{A vector with the evaulations.}
}
\description{
Evaluates the conditional posterior of Pi and Sigma using Rao-Blackwellization of the draws from the Gibbs sampler.
}
\keyword{internal}
