% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{mewTyp-class}
\alias{mewTyp-class}
\title{The state of the moving expanding window average}
\description{
The class holds the current state of the moving
expanding window (MEW) average
}
\details{
The user should never create, update or access an instance
of this class themselves.  An instance of the class should be
created with the function \code{mewInit} and updated with the
functions \code{mewAccum} and \code{mewMean}.  The user can extract
the current value of the MEW average with the function
\code{mewGetMean}, and print the first six elements of the mean
vector to the screen with either the \code{show} or \code{print}
functions.
}
\section{Slots}{

\describe{
\item{\code{i_new}}{(scalar integer) The index of the bin to add the
current sample to}

\item{\code{i_old}}{(scalar integer) The index of the bin to deweight}

\item{\code{know_mean}}{(scalar integer) flag 0: mean not known 1: mean
known}

\item{\code{n_bin}}{(scalar integer) The number of bins to use in the MEW
process}

\item{\code{n_bin_use}}{(scalar integer) The number of bins currently in
use}

\item{\code{n_xx}}{(scalar integer) The length of a vector in the sequence
being averaged}

\item{\code{n_part}}{(scalar integer) The number of samples in the bins
that are not being added to or deweighted}

\item{\code{m_sample}}{(vector integer length - n_bin) The maximum number
of samples allowed in each of the bins}

\item{\code{n_sample}}{(vector integer length - n_bin) The number of
samples currently in each bin}

\item{\code{x_mean}}{(vector double length - n_xx) The current value of the
MEW average (which is up-to-date only if \code{know_mean == 1})}

\item{\code{x_sum_part}}{(vector double length - n_xx) The sum in the bins
not being added to or deweighted}

\item{\code{xx}}{(matrix dimension - n_xx \eqn{\times} n_bin) The bin sums}

\item{\code{ff}}{(scalar double) The fraction of samples to retain in the
MEW average}

\item{\code{ww}}{(scalar double) The factor of increase in the number of
samples from one bin to the next}

\item{\code{a_sample}}{(scalar double) The ideal number of samples in a bin
(before rounding)}
}}

