% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{gpd.pll}
\alias{gpd.pll}
\title{Profile log-likelihood for the generalized Pareto distribution}
\usage{
gpd.pll(
  psi,
  param = c("scale", "shape", "quant", "VaR", "ES", "Nmean", "Nquant"),
  mod = "profile",
  mle = NULL,
  dat,
  m = NULL,
  N = NULL,
  p = NULL,
  q = NULL,
  correction = TRUE,
  threshold = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{psi}{parameter vector over which to profile (unidimensional)}

\item{param}{string indicating the parameter to profile over}

\item{mod}{string indicating the model. See \bold{Details}.}

\item{mle}{maximum likelihood estimate in \eqn{(\psi, \xi)} parametrization if \eqn{\psi \neq \xi} and \eqn{(\sigma, \xi)} otherwise (optional).}

\item{dat}{sample vector of excesses, unless \code{threshold} is provided (in which case user provides original data)}

\item{m}{number of observations of interest for return levels. Required only for \code{args} values \code{'VaR'} or \code{'ES'}}

\item{N}{size of block over which to take maxima. Required only for \code{args} \code{Nmean} and \code{Nquant}.}

\item{p}{tail probability, equivalent to \eqn{1/m}. Required only for \code{args} \code{quant}.}

\item{q}{level of quantile for N-block maxima. Required only for \code{args} \code{Nquant}.}

\item{correction}{logical indicating whether to use \code{spline.corr} to smooth the tem approximation.}

\item{threshold}{numerical threshold above which to fit the generalized Pareto distribution}

\item{plot}{logical; should the profile likelihood be displayed? Default to \code{TRUE}}

\item{...}{additional arguments such as output from call to \code{Vfun} if \code{mode='tem'}.}
}
\value{
a list with components
\itemize{
\item \code{mle}: maximum likelihood estimate
\item \code{psi.max}: maximum profile likelihood estimate
\item \code{param}: string indicating the parameter to profile over
\item \code{std.error}: standard error of \code{psi.max}
\item \code{psi}: vector of parameter \eqn{\psi} given in \code{psi}
\item \code{pll}: values of the profile log likelihood at \code{psi}
\item \code{maxpll}: value of maximum profile log likelihood
\item \code{family}: a string indicating "gpd"
\item \code{threshold}: value of the threshold, by default zero
}
In addition, if \code{mod} includes \code{tem}
\itemize{
\item \code{normal}: maximum likelihood estimate and standard error of the interest parameter \eqn{\psi}
\item \code{r}: values of likelihood root corresponding to \eqn{\psi}
\item \code{q}: vector of likelihood modifications
\item \code{rstar}: modified likelihood root vector
\item \code{rstar.old}: uncorrected modified likelihood root vector
\item \code{tem.psimax}: maximum of the tangent exponential model likelihood
}
In addition, if \code{mod} includes \code{modif}
\itemize{
\item \code{tem.mle}: maximum of tangent exponential modified profile log likelihood
\item \code{tem.profll}: values of the modified profile log likelihood at \code{psi}
\item \code{tem.maxpll}: value of maximum modified profile log likelihood
\item \code{empcov.mle}: maximum of Severini's empirical covariance modified profile log likelihood
\item \code{empcov.profll}: values of the modified profile log likelihood at \code{psi}
\item \code{empcov.maxpll}: value of maximum modified profile log likelihood
}
}
\description{
This function calculates the (modified) profile likelihood based on the \eqn{p^*} formula.
There are two small-sample corrections that use a proxy for
\eqn{\ell_{\lambda; \hat{\lambda}}}{the sample space derivative of the nuisance},
which are based on Severini's (1999) empirical covariance
and the Fraser and Reid tangent exponential model approximation.
}
\details{
The three \code{mod} available are \code{profile} (the default), \code{tem}, the tangent exponential model (TEM) approximation and
\code{modif} for the penalized profile likelihood based on \eqn{p^*} approximation proposed by Severini.
For the latter, the penalization is based on the TEM or an empirical covariance adjustment term.
}
\examples{
\dontrun{
dat <- rgp(n = 100, scale = 2, shape = 0.3)
gpd.pll(psi = seq(-0.5, 1, by=0.01), param = 'shape', dat = dat)
gpd.pll(psi = seq(0.1, 5, by=0.1), param = 'scale', dat = dat)
gpd.pll(psi = seq(20, 35, by=0.1), param = 'quant', dat = dat, p = 0.01)
gpd.pll(psi = seq(20, 80, by=0.1), param = 'ES', dat = dat, m = 100)
gpd.pll(psi = seq(15, 100, by=1), param = 'Nmean', N = 100, dat = dat)
gpd.pll(psi = seq(15, 90, by=1), param = 'Nquant', N = 100, dat = dat, q = 0.5)
}
}
