% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{pp}
\alias{pp}
\title{Poisson process of extremes.}
\arguments{
\item{par}{vector of \code{loc}, \code{scale} and \code{shape}}

\item{dat}{sample vector}

\item{u}{threshold}

\item{method}{string indicating whether to use the expected  (\code{'exp'}) or the observed (\code{'obs'} - the default) information matrix.}

\item{np}{number of periods of observations. This is a \emph{post hoc} adjustment for the intensity so that the parameters of the model coincide with those of a generalized extreme value distribution with block size \code{length(dat)/np}.}

\item{nobs}{number of observations for the expected information matrix. Default to \code{length(dat)} if \code{dat} is provided.}
}
\description{
Likelihood, score function and information matrix for the Poisson process likelihood.
}
\section{Usage}{

\preformatted{pp.ll(par, dat)
pp.ll(par, dat, u, np)
pp.score(par, dat)
pp.infomat(par, dat, method = c('obs', 'exp'))}
}

\section{Functions}{

\itemize{
\item{\code{pp.ll}:} {log likelihood}
\item{\code{pp.score}:} {score vector}
\item{\code{pp.infomat}:} {observed or expected information matrix}
}
}

\references{
Coles, S. (2001). \emph{An Introduction to Statistical Modeling of Extreme Values}, Springer, 209 p.

Wadsworth, J.L. (2016). Exploiting Structure of Maximum Likelihood Estimators for Extreme Value Threshold Selection, \emph{Technometrics}, \bold{58}(1), 116-126, \code{http://dx.doi.org/10.1080/00401706.2014.998345}.

Sharkey, P. and J.A. Tawn (2017). A Poisson process reparameterisation for Bayesian inference for extremes, \emph{Extremes}, \bold{20}(2), 239-263, \code{http://dx.doi.org/10.1007/s10687-016-0280-2}.
}
\author{
Leo Belzile
}
