% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgplikelihoods.R
\name{likmgp}
\alias{likmgp}
\title{Likelihood for multivariate generalized Pareto distribution}
\usage{
likmgp(dat, thresh, loc, scale, shape, par, model = c("br", "xstud",
  "log"), likt = c("mgp", "pois", "binom"), lambdau = 1, ...)
}
\arguments{
\item{dat}{matrix of observations}

\item{thresh}{functional threshold for the maximum}

\item{loc}{vector of location parameter for the marginal generalized Pareto distribution}

\item{scale}{vector of scale parameter for the marginal generalized Pareto distribution}

\item{shape}{vector of shape parameter for the marginal generalized Pareto distribution}

\item{par}{list of parameters: \code{alpha} for the logistic model, \code{Lambda} for the Brown--Resnick model or else \code{Sigma} and \code{df} for the extremal Student.}

\item{model}{string indicating the model family, one of \code{"log"}, \code{"br"} or \code{"xstud"}}

\item{likt}{string indicating the type of likelihood, with an additional contribution for the non-exceeding components: one of  \code{"mgp"}, \code{"binom"} and \code{"pois"}.}

\item{lambdau}{vector of marginal rate of marginal threshold exceedance.}

\item{...}{additional arguments (see Details)}
}
\value{
the value of the log-likelihood with \code{attributes} \code{expme}, giving the exponent measure
}
\description{
Likelihood for the Brown--Resnick, extremal Student or logistic vectors over region determined by
\deqn{\{y \in F: \max_{j=1}^D \sigma_j \frac{y^\xi_j-1}{\xi_j}+\mu_j  > u\};}
where \eqn{\mu} is \code{loc}, \eqn{\sigma} is \code{scale} and \eqn{\xi} is \code{shape}.
}
\details{
Optional arguments can be passed to the function via \code{...}
\itemize{
\item \code{cl} cluster instance  created by \code{makeCluster} (default to \code{NULL})
\item \code{ncors} number of cores for parallel computing of the likelihood
\item \code{mmax} maximum per column
\item \code{B1} number of replicates for quasi Monte Carlo integral for the exponent measure
\item \code{genvec1} generating vector for the quasi Monte Carlo routine (exponent measure), associated with \code{B1}
}
}
\note{
The location and scale parameters are not identifiable unless one of them is fixed.
}
