% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutils.R
\name{daggregate}
\alias{daggregate}
\title{aggregating for for data frames}
\usage{
daggregate(data, y = NULL, x = NULL, subset, ..., fun = "summary",
  regex = mets.options()$regex, missing = FALSE, remove.empty = FALSE,
  matrix = FALSE, silent = FALSE, na.action = na.pass)
}
\arguments{
\item{data}{data.frame}

\item{y}{name of variable, or formula, or names of variables on data frame.}

\item{x}{name of variable, or formula, or names of variables on data frame.}

\item{subset}{subset expression}

\item{...}{additional arguments to lower level functions}

\item{fun}{function defining aggregation}

\item{regex}{interpret x,y as regular expressions}

\item{missing}{Missing used in groups (x)}

\item{remove.empty}{remove empty groups from output}

\item{matrix}{if TRUE a matrix is returned instead of an array}

\item{silent}{suppress messages}

\item{na.action}{How model.frame deals with 'NA's}
}
\description{
aggregating for for data frames
}
\examples{
data("sTRACE",package="timereg")
daggregate(iris, "^.e.al", x="Species", fun=cor, regex=TRUE)
daggregate(iris, Sepal.Length+Petal.Length ~Species, fun=summary)
daggregate(iris, log(Sepal.Length)+I(Petal.Length>1.5) ~ Species,
                 fun=summary)
daggregate(iris, "*Length*", x="Species", fun=head)
daggregate(iris, "^.e.al", x="Species", fun=tail, regex=TRUE)
daggregate(sTRACE, status~ diabetes, fun=table)
daggregate(sTRACE, status~ diabetes+sex, fun=table)
daggregate(sTRACE, status + diabetes+sex ~ vf+I(wmi>1.4), fun=table)
daggregate(iris, "^.e.al", x="Species",regex=TRUE)
dlist(iris,Petal.Length+Sepal.Length ~ Species |Petal.Length>1.3 & Sepal.Length>5,
            n=list(1:3,-(3:1)))
daggregate(iris, I(Sepal.Length>7)~Species | I(Petal.Length>1.5))
daggregate(iris, I(Sepal.Length>7)~Species | I(Petal.Length>1.5),
                 fun=table)

dsum(iris, .~Species, matrix=TRUE, missing=TRUE)

}

