% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ipw.R
\name{ipw}
\alias{ipw}
\title{Inverse Probability of Censoring Weights}
\usage{
ipw(formula, data, cluster, same.cens = FALSE, obs.only = TRUE,
  weight.name = "w", trunc.prob = FALSE, weight.name2 = "wt",
  indi.weight = "pr", cens.model = "aalen", pairs = FALSE,
  theta.formula = ~1, ...)
}
\arguments{
\item{formula}{Formula specifying the censoring model}

\item{data}{data frame}

\item{cluster}{clustering variable}

\item{same.cens}{For clustered data, should same censoring be assumed (bivariate probability calculated as mininum of the marginal probabilities)}

\item{obs.only}{Return data with uncensored observations only}

\item{weight.name}{Name of weight variable in the new data.frame}

\item{trunc.prob}{If TRUE truncation probabilities are also calculated and stored in 'weight.name2' (based on Clayton-Oakes gamma frailty model)}

\item{weight.name2}{Name of truncation probabilities}

\item{indi.weight}{Name of individual censoring weight  in the new data.frame}

\item{cens.model}{Censoring model (default Aalens additive model)}

\item{pairs}{For paired data (e.g. twins) only the complete pairs are returned (With pairs=TRUE)}

\item{theta.formula}{Model for the dependence parameter in the Clayton-Oakes model (truncation only)}

\item{...}{Additional arguments to censoring model}
}
\description{
Internal function.
Calculates Inverse Probability of Censoring
Weights (IPCW) and adds them to a data.frame
}
\examples{
\dontrun{
data(prt)
prtw <- ipw(Surv(time,status==0)~country, data=prt[sample(nrow(prt),5000),],
            cluster="id",weight.name="w")
plot(0,type="n",xlim=range(prtw$time),ylim=c(0,1),xlab="Age",ylab="Probability")
count <- 0
for (l in unique(prtw$country)) {
    count <- count+1
    prtw <- prtw[order(prtw$time),]
    with(subset(prtw,country==l),
         lines(time,w,col=count,lwd=2))
}
legend("topright",legend=unique(prtw$country),col=1:4,pch=-1,lty=1)
}
}
\author{
Klaus K. Holst
}

