% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line.r
\name{mjs_line}
\alias{mjs_line}
\title{metricsgraphics.js linechart "geom"}
\usage{
mjs_line(mjs, area = FALSE, animate_on_load = FALSE, color = NULL,
  interpolate = "cardinal")
}
\arguments{
\item{mjs}{metricsgraphics plot object}

\item{area}{fill in area under line? (default: \code{FALSE} - no)}

\item{animate_on_load}{animate the drawing of the plot on page load? (default: \code{FALSE} - no)}

\item{color}{line color (hex string or valid HTML color string). Use \code{NULL} (the default)
to use the default Metrics Graphics colors or if you plan on controlling the colors with CSS.}

\item{interpolate}{the interpolation function to use when rendering lines.
possible values: ("cardinal", "linear", "linear-closed", "step", "step-before",
"step-after", "basis", "basis-open", "basis-closed", "bundle", "cardinal-open",
"cardinal-closed", "monotone", "basic")}
}
\value{
metricsgraphics object
}
\description{
This function adds a line "geom" to a metricsgraphics.js html widget.
}
\note{
If you plan on using cusom colors, all lines must have a color value or the result is
      non-deterministic.
}
\examples{
data.frame(year=seq(1790, 1970, 10),
           uspop=as.numeric(uspop)) \%>\%
  mjs_plot(x=year, y=uspop) \%>\%
  mjs_line()

}

