% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaErrorChecker.R
\name{betaErrorChecker}
\alias{betaErrorChecker}
\title{Wrapper for summarizing error rates of beta metric randomizations}
\usage{
betaErrorChecker(single.iteration)
}
\arguments{
\item{single.iteration}{Results of a run of the betaLinker function.}
}
\value{
A list of lists of matrices. The first element of the lists refers to the
results from a spatial simulation. Within each of these elements is a list of matrices,
where each matrix tabulates the error rate of all tested beta diversity metrics with
a given null model.
}
\description{
Given the results of a single iteration of the betaLinker function, returns a list of data
frames summarizing the type I and II error rates of 
metrics both at the single plot and the entire arena level.
}
\details{
This function wraps a number of smaller functions into a useful type I and II
error checker. It takes a reduced list of randomizations such as those reduced from
metricsNnulls with reduceRandomizations, summarizes the mean,
SD, and CI of each metric plus null model either at the richness or plot level,
then compares the observed metric scores to those summarized metrics. It return a list
with two elements. The first is a list of data frames, where each corresponds to the 
standardized effect scores of the observed metrics for a given null model. The second
is a list of data frames, where each corresponds to whether a given plot deviates
beyond CI. For the latter, 0 corresponds to within CI, 1 corresponds to less than the
CI, and 2 corresponds to greater than the CI.
}
\examples{
#run the betaLinker function
#below not run for timing issues on CRAN
#system.time(ex <- betaLinker(no.taxa=50, arena.length=300, mean.log.individuals=2, 
#length.parameter=5000, sd.parameter=50, max.distance=30, proportion.killed=0.2, 
#competition.iterations=3, no.plots=15, plot.length=30,
#randomizations=3, cores="seq",
#nulls=c("richness", "frequency")))

#test <- betaErrorChecker(ex)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
