% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filteringArena.R
\name{filteringArena}
\alias{filteringArena}
\title{Simulate a community assembled according to habitat filtering}
\usage{
filteringArena(simulations.input)
}
\arguments{
\item{simulations.input}{A prepared simulations.input object from prepSimulations}
}
\value{
A list of 3 elements: the original input regional
abundance vector, the new spatial arena, and the dimensions of that arena.
}
\description{
Given a simulations.input object, will create an arena settled according to habitat
filtering rules (and parameters defined by prepSimulations).
}
\details{
This simulation has been updated to avoid a previous consequence where
individuals clumped near the center of the arena. Now, species' spatial preferences,
which previously would have approximated a normal distribution around the center of the
arena, are smoothed to a uniform distribution. Thus, individuals are more evenly
distributed throughout the simulated arena.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
	length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
	competition.iterations=2)

test <- filteringArena(prepped)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

