% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcBetaMetrics.R
\name{calcBetaMetrics}
\alias{calcBetaMetrics}
\title{Calculate phylogenetic community structure beta metrics}
\usage{
calcBetaMetrics(metrics.input, metrics)
}
\arguments{
\item{metrics.input}{Prepped metrics.input object}

\item{metrics}{Optional list of named metric functions to use. If invoked, this option
will likely be used to run a subset of the defined metrics.}
}
\value{
A data frame with the calculated metrics and the associated species richness
and total abundance of all input "communities".
}
\description{
Given a prepped metrics.input object, calculate all phylogenetic community structure
metrics of interest.
}
\details{
This function first confirms that the input is of class metrics.input and,
if so, then confirms that the metrics to be calculated are in a named list (via
checkMetrics), then lapplies all metric functions to the input metrics.input object.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1))

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

prepped <- prepData(tree, cdm)

results <- calcBetaMetrics(prepped)

#an example of how to define ones own metrics for use in the metricTester framework
#this "metric" simply calculates the richness of each plot in the CDM
exampleMetric <- function(metrics.input)
{
output <- mean(apply(metrics.input$picante.cdm, 1, lengthNonZeros))
output
}

calcBetaMetrics(prepped, metrics=list("example"=exampleMetric))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

