% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_data_chk.R
\name{metevalue.metilene.chk}
\alias{metevalue.metilene.chk}
\title{Check the Metilene data format}
\usage{
metevalue.metilene.chk(
  input_filename_a,
  input_filename_b,
  sep = "\\t",
  bheader = FALSE
)
}
\arguments{
\item{input_filename_a}{metilene input file path. This file is a sep (e.g. TAB) separated file with two key columns and several value columns:
For exampe:

chrom    pos    g1    g1    g1    g1    g1    g1    g1    g1    g2    g2    g2    g2    g2    g2    g2    g2

chrom and pos are keys;
g1 g1 g2 g2 are samples in two experiment groups.}

\item{input_filename_b}{metilene input file path. This file should stored as a sep(e.g. TAB) separated file with two key columns and several value columns:
The columns are (in order):

    - chr:   Chromosome

    - start: The position of the start sites of the corresponding region

    - end: The position of the end sites of the corresponding region

    - q-value: The adjusted p-value based on BH method in MWU-test

    - methyl.diff: The difference between the group means of methylation level

    - CpGs:  The number of CpG sites within the corresponding region

    - p : p-value based on MWU-test

    - p2: p-value based on 2D KS-test

    - m1:  The absolute mean methylation level for the corresponding segment of group 1

    - m2:  The absolute mean methylation level for the corresponding segment of group 2}

\item{sep}{separator, default is the TAB key.}

\item{bheader}{a logical value indicating whether the input_filename_b file contains the names of the variables as its first line. By default, bheader = FALSE.}
}
\value{
list(file_a, file_b, file_a_b) returns a list with three pr-handled data.frames corresponding to the input_filename_a, input_filename_b file and a A JOIN B file.
}
\description{
Check the Metilene data format
}
\examples{
data("demo_metilene_out")
data("demo_metilene_input")
}
