% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_interpolator.R
\name{create_meteo_interpolator}
\alias{create_meteo_interpolator}
\title{Meteoland interpolator creation}
\usage{
create_meteo_interpolator(
  meteo_with_topo,
  params = NULL,
  verbose = getOption("meteoland_verbosity", TRUE)
)
}
\arguments{
\item{meteo_with_topo}{Meteo object, as returned by \code{\link{with_meteo}}}

\item{params}{Interpolation parameters as a list. Typically the result of
\code{\link{defaultInterpolationParams}}.}

\item{verbose}{Logical indicating if the function must show messages and info.
Default value checks \code{"meteoland_verbosity"} option and if not set, defaults
to TRUE. It can be turned off for the function with FALSE, or session wide with
\code{options(meteoland_verbosity = FALSE)}}
}
\value{
an interpolator object (stars)
}
\description{
Function to create the meteoland interpolator
}
\details{
This function takes meteorology information and a list of interpolation
parameters and creates the interpolator object to be ready to use.
}
\examples{

# example meteo data
data(meteoland_meteo_example)

# create the interpolator with default params
with_meteo(meteoland_meteo_example) |>
  create_meteo_interpolator()

# create the interpolator with some params changed
with_meteo(meteoland_meteo_example) |>
  create_meteo_interpolator(params = list(debug = TRUE))

}
\seealso{
Other interpolator functions: \code{\link{add_topo}()},
\code{\link{get_interpolation_params}()}, \code{\link{read_interpolator}()},
\code{\link{set_interpolation_params}()}, \code{\link{with_meteo}()},
\code{\link{write_interpolator}()}
}
