% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.copas.R
\name{print.copas}
\alias{print.copas}
\title{Print results of Copas selection model}
\usage{
\method{print}{copas}(
  x,
  backtransf = x$backtransf,
  digits = gs("digits"),
  digits.pval = max(gs("digits.pval"), 2),
  digits.prop = gs("digits.prop"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  header = TRUE,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{copas}.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If \code{backtransf =
TRUE} (default), results are printed as odds ratios rather than
log odds ratio, for example.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{digits.prop}{Minimal number of significant digits for
proportions, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{header}{A logical indicating whether information on title of
meta-analysis, comparison and outcome should be printed at the
beginning of the printout.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{...}{Additional arguments (ignored).}
}
\description{
Print method for objects of class \code{copas}.

This function prints the main results of a Copas analysis,
performed using the function \code{copas}. It complements the
graphical summary of the results, generated using
\code{\link{plot.copas}}.

Specifically it prints a table where the:

first column corresponds to the x-axis in plots 3 & 4 from
\code{plot.copas};

second column corresponds to the treatment effect displayed in plot
3 from \code{plot.copas};

third and fourth columns give the confidence intervals for this
treatment effect,

fifth colum gives the p-value for an overall treatment effect,

sixth column gives the p-value for residual publication bias (the
y-axis of plot 4 from \code{plot.copas} (see
\code{\link{plot.copas}} under plot 4 for a further explanation of
this p-value))

seventh column gives an approximate estimate of the number of
studies the model suggests remain unpublished if the probability of
publishing the study with the largest SE is as in column 1.

Below this is displayed the results of the Copas analysis (Adjusted
estimate) for the smallest degree of selection for which the
p-value for evidence of residual selection bias exceeds
\code{sign.rsb} (default: 0.1). This is simply extracted from the
corresponding row in the table above.

Lastly, the unadjusted random effects estimate and 95\% confidence
interval is printed.
}
\examples{
data(Fleiss1993bin, package = "meta")

# Perform meta analysis, effect measure is odds ratio (OR)
#
m1 <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin, sm = "OR")

# Perform Copas analysis
#
cop1 <- copas(m1)
cop1

}
\seealso{
\code{\link{copas}}, \code{\link{plot.copas}},
  \code{\link{summary.copas}}
}
\author{
James Carpenter \email{James.Carpenter@lshtm.ac.uk}, Guido
Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
