% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_power.R
\name{mod_power}
\alias{mod_power}
\title{Compute Power for Categorical Moderation Meta-analysis}
\usage{
mod_power(
  n_groups,
  effect_sizes,
  sample_size,
  k,
  es_type,
  test_type = "two-tailed",
  p = 0.05,
  sd_within = NULL,
  con_table = NULL
)
}
\arguments{
\item{n_groups}{Number of anticipated groups in moderation analysis}

\item{effect_sizes}{Expected effect sizes of for each group.}

\item{sample_size}{Expected number of participants (per group)}

\item{k}{Total expected number of studies}

\item{es_type}{'Correlation', 'd', or 'OR'}

\item{test_type}{"two-tailed" or "one-tailed"}

\item{p}{Significance level (Type I error probability)}

\item{sd_within}{(Optional) For computing power for a test of homogeneity (within-groups). standard deviation of each group to the overall mean}

\item{con_table}{(Optional) For Odds Ratio effect sizes. Expected 2x2 contingency table as a vector in the following format: c(a,b,c,d)

\tabular{lcc}{
 2x2 Table   \tab Group 1 \tab Group 2 \cr
 Present     \tab a       \tab b       \cr
 Not Present \tab c       \tab d       \cr
}}
}
\value{
Estimated Power estimates for between and within-groups moderation
}
\description{
Computes statistical power for categorical moderator models under fixed- and random-effects models
}
\examples{
mod_power(
 n_groups = 3,
 effect_sizes = c(0,.1,.55),
 sample_size = 15,
 k = 15,
 es_type = "Correlation",
 sd_within = c(1,1,4),
 test_type = "two-tailed",
 p = .05)

}
