% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.R
\name{multiplot}
\alias{multiplot}
\title{Arrange Multiple Trellis or GG Plots in a Grid}
\usage{
multiplot(..., nrow = NULL, ncol = NULL)
}
\arguments{
\item{...}{trellis or ggplot objects}

\item{nrow}{number of rows of plots}

\item{ncol}{number of columns of plots}
}
\description{
Arranges mutiple trellis plots or ggplots in a grid, automatically choosing number of rows and columns.  By default, number of rows is one less than or equal to the number of columns.
}
\examples{
library(lattice)
a <- xyplot(
conc ~ Time,
xlab=NULL,
ylab = NULL,
Theoph,
aspect = 1,
scales=list(draw=FALSE)
)
multiplot(a,a,a,a,a,a)
multiplot(a,a,a,a,a,a,a)
multiplot(a,a,a,a,a,a,a,a)
multiplot(a,a,a,a,a,a,a,a,a)
multiplot(a,a,a,a,a,a,a,a,a,a)
multiplot(a,a,a,a,a,a,a,a, nrow = 2)
multiplot(a,a,a,a,a,a,a,a, ncol = 4)
multiplot(a,a,a,a,a,a,a,a, ncol = 2)
multiplot(a,a,a,a,a,a,a,a, ncol = 4, nrow = 3)
multiplot(multiplot(a,a), a)
}
\seealso{
\code{\link[gridExtra]{grid.arrange}}
}
