% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corsplom.R
\name{corsplom_data_frame}
\alias{corsplom_data_frame}
\title{Correlated Scatterplot Matrix Function for Data Frame}
\usage{
corsplom_data_frame(x, xvar = names(x),
  upper.panel = getOption("metaplot_upper.panel", corsplom_panel_scatter),
  lower.panel = getOption("metaplot_lower.panel", corsplom_panel_correlation),
  diag.panel = getOption("metaplot_diag.panel", corsplom_panel_diagonal),
  pscales = getOption("metaplot_pscales", 0),
  xlab = getOption("metaplot_corsplom_xlab", NULL),
  varname.cex = getOption("metaplot_varname.cex", 1),
  main = getOption("metaplot_main", NULL), sub = getOption("metaplot_sub",
  NULL), ...)
}
\arguments{
\item{x}{data.frame}

\item{xvar}{variables to plot}

\item{upper.panel}{passed to splom}

\item{lower.panel}{passed to splom}

\item{diag.panel}{passed to splom}

\item{pscales}{passed to splom}

\item{xlab}{passed to splom, can be function(x = x, var = xvar, ...)}

\item{varname.cex}{passed to splom}

\item{main}{character, or a function of x, xvar}

\item{sub}{character, or a function of x, xvar}

\item{...}{extra arguments passed to \code{\link[lattice]{splom}}}
}
\description{
Creates a scatterplot matrix with correlations in lower panel, by default.
}
\seealso{
Other multivariate plots: \code{\link{corsplom.data.frame}},
  \code{\link{metaplot.data.frame}}

Other corsplom: \code{\link{corsplom.data.frame}},
  \code{\link{corsplom}}

Other metaplot: \code{\link{boxplot_data_frame}},
  \code{\link{densplot_data_frame}},
  \code{\link{metaplot}}, \code{\link{scatter_data_frame}}
}
