% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_outliers.R
\name{find_outliers}
\alias{find_outliers}
\title{Find possible outliers in a dataset}
\usage{
find_outliers(
  .data = NULL,
  var = NULL,
  by = NULL,
  plots = FALSE,
  coef = 1.5,
  verbose = TRUE,
  plot_theme = theme_metan()
)
}
\arguments{
\item{.data}{The data to be analyzed. Must be a dataframe or an object of
class \code{split_factors}.}

\item{var}{The variable to be analyzed.}

\item{by}{One variable (factor) to compute the function by. It is a shortcut
to \code{\link[dplyr:group_by]{dplyr::group_by()}}. To compute the statistics by more than
one grouping variable use that function.}

\item{plots}{If \code{TRUE}, then histograms and boxplots are shown.}

\item{coef}{The multiplication coefficient, defaults to 1.5. For more details
see \code{?boxplot.stat}.}

\item{verbose}{If \code{verbose = TRUE} then some results are shown in the
console.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Find possible outliers in the dataset.
}
\examples{
\donttest{
library(metan)

find_outliers(data_ge2, var = PH, plots = TRUE)

# Find outliers within each environment
find_outliers(data_ge2, var = PH, by = ENV)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
