% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effort_merge.R
\name{effort_merge}
\alias{effort_merge}
\title{Merges multiple files that had title/abstract screening efforts 
distributed across a team.}
\usage{
effort_merge(directory = getwd(), reviewers = NULL, dual = FALSE)
}
\arguments{
\item{directory}{The directory name for the location of multiple .csv files. 
Assumes the current working directory if none is explicitly called.
File names must include the "effort_" string as originally generated by
\code{\link{effort_distribute}}.}

\item{reviewers}{A vector of reviewer names (strings) used to merge effort 
from a select group of team members.  Must be an even collection (e.g., 
pairs of reviewers) when a dual design was implemented.}

\item{dual}{When \code{TRUE}, merges files implementing a dual screening
design.}
}
\value{
A single data.frame merged from multiple files.
}
\description{
Combines (merges) multiple effort_*.csv files within the same directory that 
represent the completed screening efforts of multiple team members.  These
files were originally generated with \code{\link{effort_distribute}}.
}
\examples{
data(example_references_metagear)
theTeam <- c("Christina", "Luc")
# warning effort_distribute below, will save two files to working 
# directory: effort_Christina.csv and effort_Luc.csv
effort_distribute(example_references_metagear, initialize = TRUE, 
                  reviewers = theTeam, save_split = TRUE)
effort_merge()

}
\seealso{
\code{\link{effort_initialize}}, \code{\link{effort_distribute}}, 
   \code{\link{effort_summary}}
}
