% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_RR.R
\name{random_RR}
\alias{random_RR}
\title{Random generation of log response ratio (RR) effect sizes.}
\usage{
random_RR(K, X_t, var_t, N_t, X_c, var_c, N_c)
}
\arguments{
\item{K}{Number of effect sizes to generate.}

\item{X_t}{The population mean (mu) of the (t)reatment group (numerator of 
ratio).}

\item{var_t}{The population variance of the treatment group mean.}

\item{N_t}{The number of samples of the treatment mean.  When a non-negative
integer, all treatment means will be estimated using the same N.  A
vector of unequal N's can also be taken; if so, K will be ignored and the 
number of randomly generated means will equal the length of that vector,
and each mean will be based on each N within the vector.}

\item{X_c}{The population mean (mu) of the (c)ontrol group (denominator of 
ratio).}

\item{var_c}{The population variance of the control group mean.}

\item{N_c}{The number of samples of the control mean.  When a non-negative
integer, all control means will be estimated using the same N.  A
vector of unequal N's can also be taken; if so, K will be ignored and the 
number of randomly generated means will equal the length of that vector,
and each mean will be based on each N within the vector.}
}
\value{
A data table with columns of random effect sizes (RR) and their 
   variances.
}
\description{
Generates random log response ratios and their variances (Hedges et al. 1999).
NOTE: samples from a log-normal distribution to generate non-negative control
and treatment means (following Lajeunesse 2015).
}
\examples{
   random_RR(K = 5, X_t = 25, var_t = 1, N_t = 15, X_c = 10, var_c = 1, N_c = 15)

}
\references{
Hedges, L.V., J. Gurevitch, and P.S. Curtis. 1999. The 
   meta-analysis of response ratios in experimental ecology. Ecology 80: 
   1150-1156.

Lajeunesse, M.J. 2015. Bias and correction for the log response
   ratio used in ecological meta-analysis. Ecology.
}

