% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{read.plumed}
\alias{read.plumed}
\title{Read 1D or 2D free energy surface from PLUMED sum_hills}
\usage{
read.plumed(file = "fes.dat", dim = 2, per = c(F, F, F))
}
\arguments{
\item{file}{input file from PLUMED sum_hills.}

\item{per}{logical vector specifying periodicity of collective variables.}

\item{dim}{dimension (1 or 2, default 2).}
}
\value{
fes object.
}
\description{
`read.plumed` reads 1D or 2D free energy surface from PLUMED sum_hills.
The grid in the (2D) inputfile must contain the same number of points
for CV1 and CV2. It does not use the header of the file. Instead, user
must specify the dimensionality (1 or 2). Periodicity must be specified
as well.
}
\examples{
l1<-"-3.142 -124.8 -44.76"
l2<-"-3.117 -125.9 -43.05"
l3<-"-3.092 -126.9 -41.22"
l4<-"-3.068 -127.9 -39.36"
l5<-"-3.043 -128.8 -37.45"
fourpoints<-c(l1,l2,l3,l4)
tf <- tempfile()
writeLines(fourpoints, tf)
read.plumed(tf, dim=1, per=c(TRUE,TRUE))
}
