Metacommunity = function (comm, scores = 1, method = "r1", sims = 1000, order = TRUE, allow.empty = FALSE, binary = TRUE, verbose = FALSE, modularity=FALSE, c=sum(dim(comm)), nstarts=10){
  if(order == TRUE){
    mat = OrderMatrix(comm, scores = scores, binary = binary)
  }else{
    mat = comm}

  nulls = NullMaker(mat, sims = sims, method = method, allow.empty = allow.empty, verbose=verbose, ordinate=order)

  coherence <- function(web) {
    zeros = which(web == 0, arr.ind = TRUE)
    ret = matrix(0, ncol = 2)
    uncols = which(colSums(web) > 1)
    for (i in 1:length(uncols)) {
      temp = zeros[which(zeros[, 2] == uncols[i]), ]
      tempmin = min(which(web[, uncols[i]] == 1))
      tempmax = max(which(web[, uncols[i]] == 1))
      if (length(temp) < 3) {
        if (temp[1] %in% tempmin:tempmax) {
          ret = rbind(ret, as.vector(temp))
        }
      } else {
        temp = temp[which(temp[, 1] %in% tempmin:tempmax), 
                    ]
        ret = rbind(ret, temp)
      }
    }
    unrows = which(rowSums(web) > 1)
    for (j in 1:length(unrows)) {
      temp = zeros[which(zeros[, 1] == unrows[j]), ]
      tempmin = min(which(web[unrows[j], ] == 1))
      tempmax = max(which(web[unrows[j], ] == 1))
      if (length(temp) < 3) {
        if (temp[1] %in% tempmin:tempmax) {
          ret = rbind(ret, as.vector(temp))
        }
      } else {
        temp = temp[which(temp[, 2] %in% tempmin:tempmax), 
                    ]
        ret = rbind(ret, temp)
      }
    }
    ret = ret[-1, ]
    ret = unique(ret)
    return(dim(ret)[1])
  }
  embabs = coherence(mat)
 simstat=unlist(lapply(nulls,coherence))
	if(length(simstat) < sims){simstat=c(simstat, rep(0, (sims-length(simstat))))}

  varstat = sd(simstat)
  z = (mean(simstat) - embabs)/(varstat)
  pval = 2 * pnorm(-abs(z))
  coh.out = data.frame(output = c(embabs, z, pval, mean(simstat), 
                                  varstat, method))
  rownames(coh.out) = c("embedded absences", "z", "pval", "sim.mean", 
                        "sim.sd", "method")
  if(modularity==FALSE){
  boundmat = BoundaryClump(mat, scores = scores, order = FALSE)
  }else{
	boundmat = Modularity(mat, method=method, scores = scores, sims=sims, order = FALSE, c=c, nstarts=nstarts)
	}

  turnover = function(web) {
    for (i in 1:dim(web)[1]) {
      temp = web[i, ]
      if (sum(temp) < 2) {
        break
      }  else {
        web[i, min(which(temp == 1)):max(which(temp == 
                                                 1))] <- 1
      }
    }
    for (j in 1:dim(web)[2]) {
      temp = web[, j]
      if (sum(temp) < 2) {
        web[, j] = temp
      } else {
        first = min(which(temp == 1))
        last = max(which(temp == 1))
        web[first:last, j] <- 1
      }
    }
    D <- designdist(web, method = "(A-J)*(B-J)", terms = "minimum")
    return(sum(D))
  }
  turn = turnover(mat)
  simstat.t = as.numeric(lapply(nulls, turnover))
  varstat.t = sd(simstat.t, na.rm=TRUE)
  z.t = (mean(simstat.t, na.rm=TRUE) - turn)/(varstat.t)
  pval.t = 2 * pnorm(-abs(z.t))
  tur = data.frame(output = c(turn, z.t, pval.t, mean(simstat.t), 
                              varstat.t, method))
  rownames(tur) = c("replacements", "z", "pval", "sim.mean", 
                    "sim.sd", "method")
if(modularity==FALSE){ret = list(Comm = mat, Coherence = coh.out, Turnover = tur, 
             Boundary = boundmat)}
if(modularity==TRUE){ret = list(Comm = mat, Coherence = coh.out, Turnover = tur, 
             Modularity = boundmat)}

  return(ret)
}
