% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_taxonomy--parsers.R
\name{class_from_class}
\alias{class_from_class}
\title{Parse embedded classifications}
\usage{
class_from_class(class, class_key, class_regex, class_sep, class_rev, database,
  ...)
}
\arguments{
\item{class}{(\code{character})
The unparsed class information.}

\item{class_key}{(\code{character} of length 1)
The identity of the capturing groups defined using \code{class_iregex}.
The length of \code{class_key} must be equal to the number of capturing groups specified in \code{class_regex}.
Any names added to the terms will be used as column names in the output.
At least \code{"taxon_id"} or \code{"name"} must be specified.
Only \code{"taxon_info"} can be used multiple times.
Each term must be one of those described below:
 \describe{
   \item{\code{taxon_id}}{A unique numeric id for a taxon for a particular \code{database} (e.g. ncbi accession number).
         Requires an internet connection.}
   \item{\code{name}}{The name of a taxon. Not necessarily unique, but are interpretable
         by a particular \code{database}. Requires an internet connection.}
   \item{\code{taxon_info}}{Arbitrary taxon info you want included in the output. Can be used more than once.}
 }}

\item{class_regex}{(\code{character} of length 1)
A regular expression with capturing groups indicating the locations of data for each taxon in the \code{class} term in the \code{key} argument.
The identity of the information must be specified using the \code{class_key} argument.}

\item{class_sep}{(\code{character} of length 1)
Used with the \code{class} term in the \code{key} argument.
The character(s) used to separate individual taxa within a classification.}

\item{class_rev}{(\code{logical} of length 1)
Used with the \code{class} term in the \code{key} argument.
If \code{TRUE}, the order of taxon data in a classification is reversed to be specific to broad.}

\item{database}{(\code{character} of length 1) The name of the database that patterns given in 
\code{parser} will apply to. Valid databases include "ncbi", "itis", "eol", "col", "tropicos",
"nbn", and "none". \code{"none"} will cause no database to be quired; use this if you want to not use the
internet. NOTE: Only \code{"ncbi"} has been tested so far.}

\item{...}{Not used}
}
\value{
\code{list} of \code{data.frame}
}
\description{
Parse embedded classifications, optionally checking the results via a database.
}
\keyword{internal}
