% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runinfo.R
\name{runinfo}
\alias{runinfo}
\title{Data set sample information}
\usage{
runinfo(technique, dataSet, dataSetDir = "DataSets", internalDir = TRUE, ...)
}
\arguments{
\item{technique}{metabolomic technique name}

\item{dataSet}{data set name}

\item{dataSetDir}{directory to store local data sets. If \code{internalDir = TRUE} this is a directory relative to the library location.}

\item{internalDir}{Logical, should the directory for storing local data sets be internal to the package location.}

\item{...}{arguments to pass to \code{downloadDataSet()}}
}
\value{
A tibble containing sample information.
}
\description{
Return tibble of run information for a given data set of a given metabolomics technique.
}
\examples{
\dontrun{
info <- runinfo(
   techniques()[1],
   dataSets(techniques()[1])[1])

head(info)
}
}
