% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaSDTdata.r
\name{metaSDTdata}
\alias{metaSDTdata}
\title{Construct metaSDTdata}
\usage{
metaSDTdata(data, type1, type2, signal)
}
\arguments{
\item{data}{Data frame to be converted. Data should be in long format with one row corresponding to a single response.}

\item{type1}{A string naming the variable containing the type 1 response, which should be an ordered factor with two levels where the first level corresponds to 'noise',}

\item{type2}{A string naming the variable containing the ordinal type 2 response, which should be an ordered factor.}

\item{signal}{A string naming the variable containing the signal.}
}
\value{
A data object of class 'metaSDTdata'. This has attributes 'L', the number of levels in the ordinal type 2 rating, and 'K' which is two times L (the number of levels of the ordinal variable 'A').
}
\description{
Constructor function for a metaSDTdata object.
}
\details{
If type1 or type 2 is not an ordered factor, the function returns a warning. The function constructs a data frame containing variables named c('type1','type2','A','signal') along with any other variable in 'data' that is not given as an argument to the function. Because of this a warning is issued when the names c('type1','type2','A','signal') are present in 'data'.
}
\examples{
metadata <- metaSDTdata(simMetaData, type1='resp', type2='conf', signal='S')

summary(metadata)
summary.data.frame(metadata)

}
