% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_suitability}
\alias{calculate_suitability}
\title{Calculate (estimate) environmental suitability}
\usage{
calculate_suitability(vmax, vopt, vmin, venv)
}
\arguments{
\item{vmax}{\verb{<numeric>} upper (i.e. maximum) tolerable value}

\item{vopt}{\verb{<numeric>} optimal (i.e. preferred) value}

\item{vmin}{\verb{<numeric>} lower (i.e. minimum) tolerable value}

\item{venv}{\verb{<numeric>} environmental value for which to calculate the suitability}
}
\value{
\verb{<numeric>} environmental suitability
}
\description{
Calculate / estimate the environmental suitability for a given environmental value,
based on a beta distribution, using the three "cardinal" values of the species for that environmental niche.
}
\details{
The environmental suitability is calculated based on a beta distribution
after a formula provided by Yin et al. (1995) and simplified by Yan and Hunt (1999) (see references paragraph)
\deqn{suitability = (\frac{V_{max} - V_{env}}{V_{max} - V_{opt}}) * (\frac{V_{env} - V_{min}}{V_{opt} - V_{min}})^{\frac{V_{opt} - V_{min}}{V_{max} - V_{opt}}}}{suitability = ((V_max - V_env) / (V_max - V_opt)) * ((V_env - V_min) / (V_opt - V_min))^((V_opt - V_min) / (V_max - V_opt)))}
}
\note{
The original formula by Yin et al. was only intended to calculate
the relative daily growth rate of plants in relation to temperature. The abstraction to
use this to A) calculate a niche suitability; and B) use it on other
environmental values than temperature might not be valid. However, the assumption that the
environmental suitability for one niche dimension is highest at one optimal value and
decreases towards the tolerable minimum and maximum values in a nonlinear fashion seems reasonable.
}
\examples{
calculate_suitability(
    vmax = 30,
    vopt = 25,
    vmin = 10,
    venv = 0:40
)
calculate_suitability(
    vmax = seq(30, 32, length.out = 40),
    vopt = seq(20, 23, length.out = 40),
    vmin = seq(9, 11, length.out = 40),
    venv = 0:40
)

try(calculate_suitability(
    vmax = 1,
    vopt = seq(20, 23, length.out = 40),
    vmin = seq(9, 11, length.out = 40),
    venv = 0:40
))
}
\references{
Yin, X., Kropff, M.J., McLaren, G., Visperas, R.M., (1995)
A nonlinear model for crop development as a function of temperature,
\emph{Agricultural and Forest Meteorology},
Volume \strong{77}, Issues 1–2,
Pages 1--16,
\doi{10.1016/0168-1923(95)02236-Q}

Also, see equation 4 in:
Weikai Yan, L.A. Hunt, (1999)
An Equation for Modelling the Temperature Response of Plants using only the Cardinal Temperatures,
\emph{Annals of Botany},
Volume \strong{84}, Issue 5,
Pages 607--614,
ISSN 0305-7364,
\doi{10.1006/anbo.1999.0955}
}
