% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGE-package.R
\docType{package}
\name{metaGE-package}
\alias{metaGE}
\alias{metaGE-package}
\title{metaGE: Meta-Analysis for Detecting Genotype x Environment Associations}
\description{
Provides functions to perform all steps of genome-wide association meta-analysis for studying Genotype x Environment interactions, from collecting the data to the manhattan plot. The procedure accounts for the potential correlation between studies. In addition to the Fixed and Random models, one can investigate the relationship between QTL effects and some qualitative or quantitative covariate via the test of contrast and the meta-regression, respectively. The methodology is available from: (De Walsche, A., et al. (2023) \doi{10.1101/2023.03.01.530237}).
}
\details{
The main functions of the package corresponding to the steps of a genome-wide association meta-analysis are:
\itemize{
\item \code{\link{metaGE.collect}}: Collect the results of genome-wide association studies data from different files.
\item \code{\link{metaGE.cor}}: Infer the correlation between studies.
\item \code{\link{metaGE.fit}}: Perform global meta-analysis test procedure for quantitative trait loci detection (using a Fixed or Random effect model)
\item \code{\link{metaGE.test}}: Perform tests of contrast or meta-regression investigate
the relationship between marker effects and some qualitative or quantitative covariate, respectively.
\item \code{\link{metaGE.lscore}}: Apply the local score approach as multiple tests correction.
\item \code{\link{metaGE.manhattan}}: Draw a Manhattan plot.
}
}
\author{
\strong{Maintainer}: Annaïg De Walsche \email{annaig.de-walsche@inrae.fr} (\href{https://orcid.org/0000-0003-0603-1716}{ORCID})

Authors:
\itemize{
  \item Tristan Mary-Huard \email{tristan.mary-huard@agroparistech.fr} (\href{https://orcid.org/0000-0002-3839-9067}{ORCID})
}

}
\keyword{internal}
