% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEscore.R
\name{metaGE.lscore}
\alias{metaGE.lscore}
\title{Compute the local score from a set of pvalues.}
\usage{
metaGE.lscore(Data, PvalName, xi)
}
\arguments{
\item{Data}{A dataset containing the following columns: CHR, POS, MARKER and PvalName.}

\item{PvalName}{The name of the column containing the p-value.}

\item{xi}{The threshold of the score, xi = 1,2,3 or 4.}
}
\value{
A list of:
\itemize{
\item Data the dataset Data with the local score as supplementary column.
\item SigZones a dataset containing informations about the significative regions.
\item SigMarker a dataset containing the signicatives markers.
\item ChrThreshold a dataset containing the chromosome-wide significance thresholds.
}
}
\description{
The function metaGE.lscore computes the local score and the significant regions from
a set of pvalues.
}
\details{
This function is directly inherited from the scorelocalfunctions.R R code file of Fariello MI, Boitard S, Mercier S, et al.,
as available on the https://forge-dga.jouy.inra.fr/projects/local-score website.
The technical details of the computation can be found in Fariello MI, Boitard S, Mercier S, et al.
Accounting for linkage disequilibrium in genome scans for selection without individual genotypes: The local score approach.
https://doi.org/10.1111/mec.14141.
The function computes a local score for the detection of significant regions based on the hypothesis that the H0 distribution of the pvalues is
uniform. Under this hypothesis the local score follows a Gumbel distribution (under H0) whose parameters depend
on the threshold \code{xi} and on the autocorrelation between pvalues within each chromosome. The threshold has
to be selected in 1,2,3,4 and the autocorrelation is computed internally.
}
\examples{
require(dplyr)
# Import the data
data("metaData")

# Compute the inter-environment correlation matrix
matCorr <- metaGE.cor(metaData, Threshold = 0.8)

# Fit the Fixed Effect model
FeDF <- metaGE.fit(metaData, matCorr, Method = "Fe")

# Compute the score local
xi <- 2
FeScore <- metaGE.lscore(FeDF,"PVALUE", xi)
#FeScore$SigZones
}
