% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_OR.R
\name{es_from_or_ci}
\alias{es_from_or_ci}
\title{Convert an odds ratio value and its 95\% confidence interval to several effect size measures}
\usage{
es_from_or_ci(
  or,
  or_ci_lo,
  or_ci_up,
  logor,
  logor_ci_lo,
  logor_ci_up,
  baseline_risk,
  small_margin_prop,
  n_exp,
  n_nexp,
  n_cases,
  n_controls,
  n_sample,
  max_asymmetry = 10,
  or_to_cor = "bonett",
  or_to_rr = "metaumbrella_cases",
  reverse_or
)
}
\arguments{
\item{or}{odds ratio value}

\item{or_ci_lo}{lower bound of the 95\% CI around the odds ratio value}

\item{or_ci_up}{upper bound of the 95\% CI around the odds ratio value}

\item{logor}{log odds ratio value}

\item{logor_ci_lo}{lower bound of the 95\% CI around the log odds ratio value}

\item{logor_ci_up}{upper bound of the 95\% CI around the log odds ratio value}

\item{baseline_risk}{proportion of cases in the non-exposed group (only required for the \code{or_to_rr = "grant"} argument).}

\item{small_margin_prop}{smallest margin proportion of the underlying 2x2 table}

\item{n_exp}{number of participants in the exposed group (only required for the \code{or_to_rr = "grant"}, and \code{or_to_rr = "metaumbrella_exp"} arguments)}

\item{n_nexp}{number of participants in the non-exposed group (only required for the \code{or_to_rr = "grant"}, and \code{or_to_rr = "metaumbrella_exp"} arguments)}

\item{n_cases}{number of cases/events}

\item{n_controls}{number of controls/no-event}

\item{n_sample}{total number of participants in the sample}

\item{max_asymmetry}{A percentage indicating the tolerance before detecting asymmetry in the 95\% CI bounds.}

\item{or_to_cor}{formula used to convert the \code{or} value into a correlation coefficient (see details).}

\item{or_to_rr}{formula used to convert the \code{or} value into a risk ratio (see details).}

\item{reverse_or}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab OR\cr
\tab \cr
\code{converted effect size measure} \tab RR + NNT\cr
\code{} \tab D + G + R + Z\cr
\tab \cr
\code{required input data} \tab See 'Section 2. Odds Ratio'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert an odds ratio value and its 95\% confidence interval to several effect size measures
}
\details{
This function computes the standard error of the (log) odds ratio
into a standard error (Section 6.5.2.2 in the Cochrane Handbook).
\deqn{logor\_se = \frac{\log{or\_ci\_up} - \log{or\_ci\_lo}}{2 * qnorm(.975)}}

Then, calculations of \code{\link{es_from_or_se}} are applied.
}
\examples{
es_or <- es_from_or_ci(
  or = 1, or_ci_lo = 0.5, or_ci_up = 2,
  n_cases = 42, n_controls = 38, baseline_risk = 0.08,
  or_to_rr = "grant"
)
}
\references{
Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
