% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_means.R
\name{es_from_ancova_means_sd_pooled_crude}
\alias{es_from_ancova_means_sd_pooled_crude}
\title{Convert adjusted means obtained from an ANCOVA model and crude pooled standard deviation of two independent groups into several effect size measures}
\usage{
es_from_ancova_means_sd_pooled_crude(
  ancova_mean_exp,
  ancova_mean_nexp,
  mean_sd_pooled,
  cov_outcome_r,
  n_cov_ancova,
  n_exp,
  n_nexp,
  smd_to_cor = "viechtbauer",
  reverse_ancova_means
)
}
\arguments{
\item{ancova_mean_exp}{adjusted mean of participants in the experimental/exposed group.}

\item{ancova_mean_nexp}{adjusted mean of participants in the non-experimental/non-exposed group.}

\item{mean_sd_pooled}{crude pooled standard deviation.}

\item{cov_outcome_r}{correlation between the outcome and covariate(s) (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the adjusted \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_means}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 19. Adjusted: Means and dispersion'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert adjusted means obtained from an ANCOVA model and crude pooled standard deviation of two independent groups into several effect size measures
}
\details{
This function first computes an "adjusted" mean difference (MD) and Cohen's d (D)
from the adjusted means and crude pooled standard deviation of two independent groups.
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate the Cohen's d}:
\deqn{d =  \frac{ancova\_mean\_exp - ancova\_mean\_nexp\_adj}{mean\_sd\_pooled}}

\strong{To estimate the mean difference}:
\deqn{md =  ancova\_mean\_exp - ancova\_mean\_nexp\_adj}
\deqn{md\_se =  \sqrt{\frac{n\_exp + n\_nexp}{n\_exp * n\_nexp} * (1 - cov\_outcome\_r^2) * mean\_sd\_pooled^2}}

Then, calculations of the \code{\link{es_from_ancova_means_sd}()} and \code{\link{es_from_cohen_d_adj}()} are applied.
}
\examples{
es_from_ancova_means_sd_pooled_crude(
  ancova_mean_exp = 29, ancova_mean_nexp = 34,
  mean_sd_pooled = 7, cov_outcome_r = 0.2,
  n_cov_ancova = 3, n_exp = 20, n_nexp = 20
)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
