% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.meta.R
\name{update.meta}
\alias{update.meta}
\title{Update a meta-analysis object}
\usage{
\method{update}{meta}(
  object,
  data = object$data,
  subset,
  studlab,
  exclude,
  cluster,
  rho = object$rho,
  method,
  sm = object$sm,
  incr,
  method.incr = object$method.incr,
  allstudies = object$allstudies,
  MH.exact = object$MH.exact,
  RR.Cochrane = object$RR.Cochrane,
  Q.Cochrane = object$Q.Cochrane,
  model.glmm = object$model.glmm,
  level = object$level,
  level.ma = object$level.ma,
  common = object$common,
  random = object$random,
  overall = object$overall,
  overall.hetstat = object$overall.hetstat,
  method.random.ci = object$method.random.ci,
  adhoc.hakn.ci = object$adhoc.hakn.ci,
  method.predict = object$method.predict,
  adhoc.hakn.pi = object$adhoc.hakn.pi,
  seed.predict = object$seed.predict,
  method.tau = object$method.tau,
  method.tau.ci = object$method.tau.ci,
  tau.preset = object$tau.preset,
  TE.tau = object$TE.tau,
  tau.common = object$tau.common,
  prediction = object$prediction,
  level.predict = object$level.predict,
  null.effect = object$null.effect,
  method.bias = object$method.bias,
  backtransf = object$backtransf,
  pscale = object$pscale,
  irscale = object$irscale,
  irunit = object$irunit,
  text.common = object$text.common,
  text.random = object$text.random,
  text.predict = object$text.predict,
  text.w.common = object$text.w.common,
  text.w.random = object$text.w.random,
  title = object$title,
  complab = object$complab,
  outclab = object$outclab,
  label.e = object$label.e,
  label.c = object$label.c,
  label.left = object$label.left,
  label.right = object$label.right,
  n.e = object$n.e,
  n.c = object$n.c,
  method.mean = object$method.mean,
  method.sd = object$method.sd,
  approx.mean.e = object$approx.mean.e,
  approx.mean.c = object$approx.mean.c,
  approx.sd.e = object$approx.sd.e,
  approx.sd.c = object$approx.sd.c,
  approx.mean = object$approx.mean,
  approx.sd = object$approx.sd,
  approx.TE = object$approx.TE,
  approx.seTE = object$approx.seTE,
  pooledvar = object$pooledvar,
  method.smd = object$method.smd,
  sd.glass = object$sd.glass,
  exact.smd = object$exact.smd,
  method.ci = object$method.ci,
  subgroup,
  subgroup.name = object$subgroup.name,
  print.subgroup.name = object$print.subgroup.name,
  sep.subgroup = object$sep.subgroup,
  test.subgroup = object$test.subgroup,
  prediction.subgroup = object$prediction.subgroup,
  seed.predict.subgroup = object$seed.predict.subgroup,
  byvar,
  id,
  print.CMH = object$print.CMH,
  keepdata = TRUE,
  left = object$left,
  ma.common = object$ma.common,
  type = object$type,
  n.iter.max = object$n.iter.max,
  warn = FALSE,
  warn.deprecated = gs("warn.deprecated"),
  verbose = FALSE,
  control = object$control,
  ...
)
}
\arguments{
\item{object}{An object of class \code{meta}.}

\item{data}{Dataset.}

\item{subset}{Subset.}

\item{studlab}{Study label.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{cluster}{An optional vector specifying which estimates come
from the same cluster resulting in the use of a three-level
meta-analysis model.}

\item{rho}{Assumed correlation of estimates within a cluster.}

\item{method}{A character string indicating which method is to be
used for pooling of studies (see \code{\link{metabin}},
\code{\link{metainc}}, \code{\link{metaprop}} and
\code{\link{metarate}}).}

\item{sm}{A character string indicating which summary measure is
used for pooling.}

\item{incr}{Information on increment added to cell frequencies of
studies with zero cell counts (see \code{\link{metabin}},
\code{\link{metainc}}, \code{\link{metaprop}} and
\code{\link{metarate}}).}

\item{method.incr}{A character string indicating which continuity
correction method should be used (see \code{\link{metabin}},
\code{\link{metainc}}, \code{\link{metaprop}} and
\code{\link{metarate}}).}

\item{allstudies}{A logical indicating if studies with zero or all
events in both groups are to be included in the meta-analysis
(applies only to \code{\link{metabin}} object with \code{sm}
equal to \code{"RR"} or \code{"OR"}).}

\item{MH.exact}{A logical indicating if \code{incr} is not to be
added to all cell frequencies for studies with a zero cell count
to calculate the pooled estimate based on the Mantel-Haenszel
method (applies only to \code{\link{metabin}} object).}

\item{RR.Cochrane}{A logical indicating which method to use as
continuity correction for the risk ratio (see
\code{\link{metabin}}).}

\item{Q.Cochrane}{A logical indicating which method to use to
calculate the heterogeneity statistic Q (see
\code{\link{metabin}}).}

\item{model.glmm}{A character string indicating which GLMM model
should be used (see \code{\link{metabin}} and
\code{\link{metainc}}).}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{method.random.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
random effects estimate (see \code{\link{meta-package}}).}

\item{adhoc.hakn.ci}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied in the case
of an arbitrarily small Hartung-Knapp variance estimate (see
\code{\link{meta-package}}).}

\item{method.predict}{A character string indicating which method is
used to calculate a prediction interval (see
\code{\link{meta-package}}).}

\item{adhoc.hakn.pi}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied for
prediction interval (see \code{\link{meta-package}}).}

\item{seed.predict}{A numeric value used as seed to calculate
bootstrap prediction interval (see \code{\link{meta-package}}).}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau} (see \code{\link{meta-package}}).}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau} (see \code{\link{meta-package}}).}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test for
funnel plot asymmetry is to be used, can be abbreviated. See
function \code{\link{metabias}.}}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If \code{backtransf =
TRUE}, results for \code{sm = "OR"} are printed as odds ratios
rather than log odds ratios and results for \code{sm = "ZCOR"}
are printed as correlations rather than Fisher's z transformed
correlations, for example.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{label.e}{Label for experimental group.}

\item{label.c}{Label for control group.}

\item{label.left}{Graph label on left side of forest plot.}

\item{label.right}{Graph label on right side of forest plot.}

\item{n.e}{Number of observations in experimental group (only for
\code{\link{metagen}} object).}

\item{n.c}{Number of observations in control group (only for
metagen object).}

\item{method.mean}{A character string indicating which method to
use to approximate the mean from the median and other statistics
(see \code{\link{metacont}} and \code{\link{metamean}}).}

\item{method.sd}{A character string indicating which method to use
to approximate the standard deviation from sample size, median,
interquartile range and range (see \code{\link{metacont}} and
\code{\link{metamean}}).}

\item{approx.mean.e}{Approximation method to estimate means in
experimental group (see \code{\link{metacont}}).}

\item{approx.mean.c}{Approximation method to estimate means in
control group (see \code{\link{metacont}}).}

\item{approx.sd.e}{Approximation method to estimate standard
deviations in experimental group (see \code{\link{metacont}}).}

\item{approx.sd.c}{Approximation method to estimate standard
deviations in control group (see \code{\link{metacont}}).}

\item{approx.mean}{Approximation method to estimate means (see
\code{\link{metamean}}).}

\item{approx.sd}{Approximation method to estimate standard
deviations (see \code{\link{metamean}}).}

\item{approx.TE}{Approximation method to estimate treatment
estimate (see \code{\link{metagen}}).}

\item{approx.seTE}{Approximation method to estimate standard error
(see \code{\link{metagen}}).}

\item{pooledvar}{A logical indicating if a pooled variance should
be used for the mean difference or ratio of means (see
\code{\link{metacont}}).}

\item{method.smd}{A character string indicating which method is
used to estimate the standardised mean difference (see
\code{\link{metacont}}).}

\item{sd.glass}{A character string indicating which standard
deviation is used in the denominator for Glass' method to
estimate the standardised mean difference (only for metacont
object with \code{sm = "SMD"}). Either \code{"control"} using the
standard deviation in the control group (\code{sd.c}) or
\code{"experimental"} using the standard deviation in the
experimental group (\code{sd.e}), can be abbreviated.}

\item{exact.smd}{A logical indicating whether exact formulae should
be used in estimation of the standardised mean difference and its
standard error.}

\item{method.ci}{A character string indicating which method is used
to calculate confidence intervals for individual studies. Either
\code{"z"}, \code{"t"}, \code{"WS"}, \code{"WSCC"}, \code{"AC"},
\code{"SA"}, \code{"SACC"}, \code{"NAsm"}, or \code{"Poisson"},
can be abbreviated. See functions \code{\link{metacont}},
\code{\link{metaprop}} and \code{\link{metarate}}.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{seed.predict.subgroup}{A numeric vector providing seeds to
calculate bootstrap prediction intervals within subgroups. Must
be of same length as the number of subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{id}{Deprecated argument (replaced by 'cluster').}

\item{print.CMH}{A logical indicating whether result of the
Cochran-Mantel-Haenszel test for overall effect should be
printed.}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{left}{A logical indicating whether studies are supposed to be
missing on the left or right side of the funnel plot. If NULL,
the linear regression test for funnel plot symmetry (i.e.,
function \code{metabias(..., method = "linreg")}) is used to
determine whether studies are missing on the left or right side.}

\item{ma.common}{A logical indicating whether a common effect or
random effects model is used to estimate the number of missing
studies.}

\item{type}{A character indicating which method is used to estimate
the number of missing studies. Either \code{"L"} or \code{"R"}.}

\item{n.iter.max}{Maximum number of iterations to estimate number
of missing studies.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if \code{incr} is added to studies with zero cell
frequencies).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{verbose}{A logical indicating whether to print information on
updates of older meta versions.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}} or
\code{\link[metafor]{rma.glmm}}, respectively.}

\item{\dots}{Additional arguments (ignored at the moment).}
}
\value{
An object of class \code{"meta"} and \code{"metabin"},
\code{"metacont"}, \code{"metacor"}, \code{"metainc"},
\code{"metagen"}, \code{"metamean"}, \code{"metaprop"}, or
\code{"metarate"} (see \code{\link{meta-object}}).
}
\description{
Update an existing meta-analysis object.
}
\details{
Wrapper function to update an existing meta-analysis object which
was created with R function \code{\link{metabin}},
\code{\link{metacont}}, \code{\link{metacor}},
\code{\link{metagen}}, \code{\link{metainc}},
\code{\link{metamean}}, \code{\link{metaprop}}, or
\code{\link{metarate}}. More details on function arguments are
available in help files of respective R functions.

This function can also be used for objects of class 'trimfill',
'metacum', and 'metainf'.
}
\examples{
data(Fleiss1993cont)
m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, studlab = paste(study, year), sm = "SMD")
m1

# Change summary measure (from 'SMD' to 'MD')
#
update(m1, sm = "MD")

# Restrict analysis to subset of studies
#
update(m1, subset = 1:2)

# Use different levels for confidence intervals
#
m2 <- update(m1, level = 0.66, level.ma = 0.99)
print(m2, digits = 2)
forest(m2)

}
\seealso{
\code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metacor}}, \code{\link{metagen}},
  \code{\link{metainc}}, \code{\link{metamean}},
  \code{\link{metaprop}}, \code{\link{metarate}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
