% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacont.R
\name{metacont}
\alias{metacont}
\title{Meta-analysis of continuous outcome data}
\usage{
metacont(
  n.e,
  mean.e,
  sd.e,
  n.c,
  mean.c,
  sd.c,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  cluster = NULL,
  rho = 0,
  median.e,
  q1.e,
  q3.e,
  min.e,
  max.e,
  median.c,
  q1.c,
  q3.c,
  min.c,
  max.c,
  method.mean = "Luo",
  method.sd = "Shi",
  approx.mean.e,
  approx.mean.c = approx.mean.e,
  approx.sd.e,
  approx.sd.c = approx.sd.e,
  sm = gs("smcont"),
  method.ci = gs("method.ci.cont"),
  level = gs("level"),
  pooledvar = gs("pooledvar"),
  method.smd = gs("method.smd"),
  sd.glass = gs("sd.glass"),
  exact.smd = gs("exact.smd"),
  common = gs("common"),
  random = gs("random") | !is.null(tau.preset),
  overall = common | random,
  overall.hetstat = if (is.null(gs("overall.hetstat"))) common | random else
    gs("overall.hetstat"),
  prediction = gs("prediction") | !missing(method.predict),
  method.tau = gs("method.tau"),
  method.tau.ci = gs("method.tau.ci"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  level.ma = gs("level.ma"),
  method.random.ci = gs("method.random.ci"),
  adhoc.hakn.ci = gs("adhoc.hakn.ci"),
  level.predict = gs("level.predict"),
  method.predict = gs("method.predict"),
  adhoc.hakn.pi = gs("adhoc.hakn.pi"),
  seed.predict = NULL,
  method.bias = gs("method.bias"),
  backtransf = gs("backtransf"),
  text.common = gs("text.common"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.common = gs("text.w.common"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  label.e = gs("label.e"),
  label.c = gs("label.c"),
  label.left = gs("label.left"),
  label.right = gs("label.right"),
  subgroup,
  subgroup.name = NULL,
  print.subgroup.name = gs("print.subgroup.name"),
  sep.subgroup = gs("sep.subgroup"),
  test.subgroup = gs("test.subgroup"),
  prediction.subgroup = gs("prediction.subgroup"),
  seed.predict.subgroup = NULL,
  byvar,
  id,
  adhoc.hakn,
  keepdata = gs("keepdata"),
  warn = gs("warn"),
  warn.deprecated = gs("warn.deprecated"),
  control = NULL,
  ...
)
}
\arguments{
\item{n.e}{Number of observations in experimental group.}

\item{mean.e}{Estimated mean in experimental group.}

\item{sd.e}{Standard deviation in experimental group.}

\item{n.c}{Number of observations in control group.}

\item{mean.c}{Estimated mean in control group.}

\item{sd.c}{Standard deviation in control group.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{cluster}{An optional vector specifying which estimates come
from the same cluster resulting in the use of a three-level
meta-analysis model.}

\item{rho}{Assumed correlation of estimates within a cluster.}

\item{median.e}{Median in experimental group (used to estimate the
mean and standard deviation).}

\item{q1.e}{First quartile in experimental group (used to estimate
the mean and standard deviation).}

\item{q3.e}{Third quartile in experimental group (used to estimate
the mean and standard deviation).}

\item{min.e}{Minimum in experimental group (used to estimate the
mean and standard deviation).}

\item{max.e}{Maximum in experimental group (used to estimate the
mean and standard deviation).}

\item{median.c}{Median in control group (used to estimate the mean
and standard deviation).}

\item{q1.c}{First quartile in control group (used to estimate the
mean and standard deviation).}

\item{q3.c}{Third quartile in control group (used to estimate the
mean and standard deviation).}

\item{min.c}{Minimum in control group (used to estimate the mean
and standard deviation).}

\item{max.c}{Maximum in control group (used to estimate the mean
and standard deviation).}

\item{method.mean}{A character string indicating which method to
use to approximate the mean from the median and other statistics
(see Details).}

\item{method.sd}{A character string indicating which method to use
to approximate the standard deviation from sample size, median,
interquartile range and range (see Details).}

\item{approx.mean.e}{Approximation method to estimate means in
experimental group (see Details).}

\item{approx.mean.c}{Approximation method to estimate means in
control group (see Details).}

\item{approx.sd.e}{Approximation method to estimate standard
deviations in experimental group (see Details).}

\item{approx.sd.c}{Approximation method to estimate standard
deviations in control group (see Details).}

\item{sm}{A character string indicating which summary measure
(\code{"MD"}, \code{"SMD"}, or \code{"ROM"}) is to be used for
pooling of studies.}

\item{method.ci}{A character string indicating which method is used
to calculate confidence intervals for individual studies (see
Details).}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{pooledvar}{A logical indicating if a pooled variance should
be used for the mean difference (\code{sm="MD"}) or ratio of
means (\code{sm="ROM"}).}

\item{method.smd}{A character string indicating which method is
used to estimate the standardised mean difference
(\code{sm="SMD"}). Either \code{"Hedges"} for Hedges' g
(default), \code{"Cohen"} for Cohen's d, or \code{"Glass"} for
Glass' delta, can be abbreviated.}

\item{sd.glass}{A character string indicating which standard
deviation is used in the denominator for Glass' method to
estimate the standardised mean difference. Either
\code{"control"} using the standard deviation in the control
group (\code{sd.c}) or \code{"experimental"} using the standard
deviation in the experimental group (\code{sd.e}), can be
abbreviated.}

\item{exact.smd}{A logical indicating whether exact formulae should
be used in estimation of the standardised mean difference and its
standard error (see Details).}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau} (see \code{\link{meta-package}}).}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau} (see \code{\link{meta-package}}).}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{method.random.ci}{A character string indicating which method
is used to calculate confidence interval and test statistic for
random effects estimate (see \code{\link{meta-package}}).}

\item{adhoc.hakn.ci}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied in the case
of an arbitrarily small Hartung-Knapp variance estimate (see
\code{\link{meta-package}}).}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{method.predict}{A character string indicating which method is
used to calculate a prediction interval (see
\code{\link{meta-package}}).}

\item{adhoc.hakn.pi}{A character string indicating whether an
\emph{ad hoc} variance correction should be applied for
prediction interval (see \code{\link{meta-package}}).}

\item{seed.predict}{A numeric value used as seed to calculate
bootstrap prediction interval (see \code{\link{meta-package}}).}

\item{method.bias}{A character string indicating which test is to
be used. Either \code{"Begg"}, \code{"Egger"}, \code{"Thompson"},
or \code{"Pustejovsky"} (see \code{\link{metabias}}), can be
abbreviated.}

\item{backtransf}{A logical indicating whether results for ratio of
means (\code{sm="ROM"}) should be back transformed in printouts
and plots. If TRUE (default), results will be presented as ratio
of means; otherwise log ratio of means will be shown.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{label.e}{Label for experimental group.}

\item{label.c}{Label for control group.}

\item{label.left}{Graph label on left side of forest plot.}

\item{label.right}{Graph label on right side of forest plot.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{seed.predict.subgroup}{A numeric vector providing seeds to
calculate bootstrap prediction intervals within subgroups. Must
be of same length as the number of subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{id}{Deprecated argument (replaced by 'cluster').}

\item{adhoc.hakn}{Deprecated argument (replaced by
'adhoc.hakn.ci').}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether warnings should be printed
(e.g., if studies are excluded from meta-analysis due to zero
standard deviations).}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}}.}

\item{\dots}{Additional arguments (to catch deprecated arguments).}
}
\value{
An object of class \code{c("metacont", "meta")} with corresponding
generic functions (see \code{\link{meta-object}}).
}
\description{
Calculation of common and random effects estimates for meta-analyses
with continuous outcome data; inverse variance weighting is used
for pooling.
}
\details{
Calculation of common and random effects estimates for meta-analyses
with continuous outcome data; inverse variance weighting is used
for pooling.

A three-level random effects meta-analysis model (Van den Noortgate
et al., 2013) is utilized if argument \code{cluster} is used and at
least one cluster provides more than one estimate. Internally,
\code{\link[metafor]{rma.mv}} is called to conduct the analysis and
\code{\link[metafor]{weights.rma.mv}} with argument \code{type =
"rowsum"} is used to calculate random effects weights.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

Three different types of summary measures are available for continuous
outcomes:
\itemize{
\item mean difference (argument \code{sm = "MD"})
\item standardised mean difference (\code{sm = "SMD"})
\item ratio of means (\code{sm = "ROM"})
}

\subsection{Standardised mean difference}{

For the standardised mean difference three methods are implemented:
\itemize{
\item Hedges' g (default, \code{method.smd = "Hedges"}) - see
  Hedges (1981)
\item Cohen's d (\code{method.smd = "Cohen"}) - see Cohen (1988)
\item Glass' delta (\code{method.smd = "Glass"}) - see Glass (1976)
}

Hedges (1981) calculated the exact bias in Cohen's d which is a
ratio of gamma distributions with the degrees of freedom,
i.e. total sample size minus two, as argument. By default (argument
\code{exact.smd = FALSE}), an accurate approximation of this bias
provided in Hedges (1981) is utilised for Hedges' g as well as its
standard error; these approximations are also used in RevMan
5. Following Borenstein et al. (2009) these approximations are not
used in the estimation of Cohen's d. White and Thomas (2005) argued
that approximations are unnecessary with modern software and
accordingly promote to use the exact formulae; this is possible
using argument \code{exact.smd = TRUE}. For Hedges' g the exact
formulae are used to calculate the standardised mean difference as
well as the standard error; for Cohen's d the exact formula is only
used to calculate the standard error. In typical applications (with
sample sizes above 10), the differences between using the exact
formulae and the approximation will be minimal.

For Glass' delta, by default (argument \code{sd.glass =
"control"}), the standard deviation in the control group
(\code{sd.c}) is used in the denominator of the standard mean
difference. The standard deviation in the experimental group
(\code{sd.e}) can be used by specifying \code{sd.glass =
"experimental"}.
}

\subsection{Ratio of means}{

Meta-analysis of ratio of means -- also called response ratios --
is described in Hedges et al. (1999) and Friedrich et al. (2008).
Calculations are conducted on the log scale and list elements
\code{TE}, \code{TE.common}, and \code{TE.random} contain the
logarithm of the ratio of means. In printouts and plots these
values are back transformed if argument \code{backtransf = TRUE}.
}

\subsection{Approximate means from sample sizes, medians and other statistics}{

Missing means in the experimental group (analogously for the
control group) can be derived from
\enumerate{
\item sample size, median, interquartile range and range (arguments
  \code{n.e}, \code{median.e}, \code{q1.e}, \code{q3.e},
  \code{min.e}, and \code{max.e}),
\item sample size, median and interquartile range (arguments
  \code{n.e}, \code{median.e}, \code{q1.e}, and \code{q3.e}), or
\item sample size, median and range (arguments \code{n.e},
  \code{median.e}, \code{min.e}, and \code{max.e}).
}

By default, methods described in Luo et al. (2018) are utilized
(argument \code{method.mean = "Luo"}):
\itemize{
\item equation (15) if sample size, median, interquartile range and 
  range are available,
\item equation (11) if sample size, median and interquartile range
  are available,
\item equation (7) if sample size, median and range are available.
}

Instead the methods described in Wan et al. (2014) are used if
argument \code{method.mean = "Wan"}:
\itemize{
\item equation (10) if sample size, median, interquartile range and 
  range are available,
\item equation (14) if sample size, median and interquartile range
  are available,
\item equation (2) if sample size, median and range are available.
}

The following methods are also available to estimate means from
quantiles or ranges if R package \bold{estmeansd} is installed:
\itemize{
\item Method for Unknown Non-Normal Distributions (MLN) approach
  (Cai et al. (2021), argument \code{method.mean = "Cai"}),
\item Quantile Estimation (QE) method (McGrath et al. (2020),
  argument \code{method.mean = "QE-McGrath"})),
\item Box-Cox (BC) method (McGrath et al. (2020),
  argument \code{method.mean = "BC-McGrath"})).
}

By default, missing means are replaced successively using
interquartile ranges and ranges (if available), interquartile
ranges (if available) and finally ranges. Arguments
\code{approx.mean.e} and \code{approx.mean.c} can be used to
overwrite this behaviour for each individual study and treatment
arm:
\itemize{
\item use means directly (entry \code{""} in argument
  \code{approx.mean.e} or \code{approx.mean.c});
\item median, interquartile range and range (\code{"iqr.range"});
\item median and interquartile range (\code{"iqr"});
\item median and range (\code{"range"}).
}
}

\subsection{Approximate standard deviations from sample sizes,
medians and other statistics}{

Missing standard deviations in the experimental group (analogously
for the control group) can be derived from
\enumerate{
\item sample size, median, interquartile range and range (arguments
  \code{n.e}, \code{median.e}, \code{q1.e}, \code{q3.e},
  \code{min.e}, and \code{max.e}),
\item sample size, median and interquartile range (arguments
  \code{n.e}, \code{median.e}, \code{q1.e} and \code{q3.e}), or
\item sample size, median and range (arguments \code{n.e},
  \code{median.e}, \code{min.e} and \code{max.e}).
}

Wan et al. (2014) describe methods to estimate the standard
deviation from the sample size, median and additional
statistics. Shi et al. (2020) provide an improved estimate of the
standard deviation if the interquartile range and range are
available in addition to the sample size and median. Accordingly,
equation (11) in Shi et al. (2020) is the default (argument
\code{method.sd = "Shi"}), if the median, interquartile range and
range are provided. The method by Wan et al. (2014) is used if
argument \code{method.sd = "Wan"} and, depending on the sample
size, either equation (12) or (13) is used. If only the
interquartile range or range is available, equations (15) / (16)
and (7) / (9) in Wan et al. (2014) are used, respectively.

The following methods are also available to estimate standard
deviations from quantiles or ranges if R package \bold{estmeansd}
is installed:
\itemize{
\item Method for Unknown Non-Normal Distributions (MLN) approach
  (Cai et al. (2021), argument \code{method.mean = "Cai"}),
\item Quantile Estimation (QE) method (McGrath et al. (2020),
  argument \code{method.mean = "QE-McGrath"})),
\item Box-Cox (BC) method (McGrath et al. (2020),
  argument \code{method.mean = "BC-McGrath"})).
}

By default, missing standard deviations are replaced successively
using these method, i.e., interquartile ranges and ranges are used
before interquartile ranges before ranges. Arguments
\code{approx.sd.e} and \code{approx.sd.c} can be used to overwrite
this default for each individual study and treatment arms:
\itemize{
\item sample size, median, interquartile range and range
  (\code{"iqr.range"});
\item sample size, median and interquartile range (\code{"iqr"});
\item sample size, median and range (\code{"range"}).
}
}

\subsection{Confidence intervals for individual studies}{

For the mean difference (argument \code{sm = "MD"}), the confidence
interval for individual studies can be based on the
\itemize{
\item standard normal distribution (\code{method.ci = "z"}, default), or
\item t-distribution (\code{method.ci = "t"}).
}

Note, this choice does not affect the results of the common effect
and random effects meta-analysis.
}

\subsection{Subgroup analysis}{

Argument \code{subgroup} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples in \code{\link{metagen}}).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both common effect and random effects models are
calculated regardless of values choosen for arguments \code{common}
and \code{random}. Accordingly, the estimate for the random effects
model can be extracted from component \code{TE.random} of an object
of class \code{"meta"} even if argument \code{random =
FALSE}. However, all functions in R package \bold{meta} will
adequately consider the values for \code{common} and
\code{random}. E.g. function \code{\link{print.meta}} will not
print results for the random effects model if \code{random =
FALSE}.

A prediction interval will only be shown if \code{prediction =
TRUE}.
}
}
\note{
The function \code{\link{metagen}} is called internally to
calculate individual and overall treatment estimates and standard
errors.
}
\examples{
data(Fleiss1993cont)

# Meta-analysis with Hedges' g as effect measure
#
m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "SMD")
m1
forest(m1)

# Use Cohen's d instead of Hedges' g as effect measure
#
update(m1, method.smd = "Cohen")

# Use Glass' delta instead of Hedges' g as effect measure
#
update(m1, method.smd = "Glass")

# Use Glass' delta based on the standard deviation in the experimental group
#
update(m1, method.smd = "Glass", sd.glass = "experimental")

# Calculate Hedges' g based on exact formulae
#
update(m1, exact.smd = TRUE)

data(amlodipine)
m2 <- metacont(n.amlo, mean.amlo, sqrt(var.amlo),
  n.plac, mean.plac, sqrt(var.plac),
  data = amlodipine, studlab = study)
m2

# Use pooled variance
#
update(m2, pooledvar = TRUE)

# Meta-analysis of response ratios (Hedges et al., 1999)
#
data(woodyplants)
m3 <- metacont(n.elev, mean.elev, sd.elev, n.amb, mean.amb, sd.amb,
  data = woodyplants, sm = "ROM")
m3
print(m3, backtransf = FALSE)

}
\references{
Borenstein M, Hedges LV, Higgins JPT, Rothstein HR (2009):
\emph{Introduction to Meta-Analysis}.
Chichester: Wiley

Cai S, Zhou J, Pan J (2021):
Estimating the sample mean and standard deviation from order
statistics and sample size in meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{30}, 2701--2719

Cohen J (1988):
\emph{Statistical Power Analysis for the Behavioral Sciences
  (second ed.)}.
Lawrence Erlbaum Associates

Friedrich JO, Adhikari NK, Beyene J (2008):
The ratio of means method as an alternative to mean differences for
analyzing continuous outcome variables in meta-analysis: A
simulation study.
\emph{BMC Medical Research Methodology},
\bold{8}, 32

Glass G (1976):
Primary, secondary, and meta-analysis of research.
\emph{Educational Researcher},
\bold{5}, 3--8

Hedges LV (1981):
Distribution theory for Glass's estimator of effect size and
related estimators.
\emph{Journal of Educational and Behavioral Statistics},
\bold{6}, 107--28

Hedges LV, Gurevitch J, Curtis PS (1999):
The meta-analysis of response ratios in experimental ecology.
\emph{Ecology},
\bold{80}, 1150--6

Luo D, Wan X, Liu J, Tong T (2018):
Optimally estimating the sample mean from the sample size, median,
mid-range, and/or mid-quartile range.
\emph{Statistical Methods in Medical Research},
\bold{27}, 1785--805

McGrath S, Zhao X, Steele R, et al. and the DEPRESsion Screening
Data (DEPRESSD) Collaboration (2020):
Estimating the sample mean and standard deviation from commonly
reported quantiles in meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{29}, 2520--2537

\emph{Review Manager (RevMan)} [Computer program]. Version 5.4.
The Cochrane Collaboration, 2020

Shi J, Luo D, Weng H, Zeng XT, Lin L, Chu H, Tong T (2020):
Optimally estimating the sample standard deviation from the
five-number summary.
\emph{Research Synthesis Methods},
\bold{11}, 641--54

Van den Noortgate W, López-López JA, Marín-Martínez F, Sánchez-Meca J (2013):
Three-level meta-analysis of dependent effect sizes.
\emph{Behavior Research Methods},
\bold{45}, 576--94

Wan X, Wang W, Liu J, Tong T (2014):
Estimating the sample mean and standard deviation from the sample
size, median, range and/or interquartile range.
\emph{BMC Medical Research Methodology},
\bold{14}, 135

White IR, Thomas J (2005):
Standardized mean differences in individually-randomized and
cluster-randomized trials, with applications to meta-analysis.
\emph{Clinical Trials},
\bold{2}, 141--51
}
\seealso{
\code{\link{meta-package}}, \code{\link{update.meta}},
  \code{\link{metabin}}, \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
