% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getID.R
\name{getId}
\alias{getId}
\title{Filter environmental monitoring stations by identifier type}
\usage{
getId(id, ...)
}
\arguments{
\item{id}{(character) identifier(s) of interest.  Metadata are available for stations with any of the identifiers listed below. It should be noted that a station may have multiple, associated identifers.  For instance, a single station may have COOP, GHCND, and FAA identifiers.  See reference links for further information.\cr
\cr
AIRMon: Atmospheric Integrated Research Monitoring Network\cr
\url{http://nadp.sws.uiuc.edu/AIRMoN/}\cr
\cr
AMNet: Atmospheric Mercury Network\cr
\url{http://nadp.sws.uiuc.edu/amn/}\cr
\cr
AMoN: Ammonia Monitoring Netowkr\cr
\url{http://nadp.sws.uiuc.edu/AMoN/}\cr
\cr
BOR: Bureau of Reclamation \cr
\url{https://www.wcc.nrcs.usda.gov/wsf/wsf-reservoir.html}\cr
\cr
COOP: Cooperative Observer Network\cr
\url{https://www.ncdc.noaa.gov/data-access/land-based-station-data/land-based-datasets/cooperative-observer-network-coop}\cr
\cr
FAA: Federal Aviation Administration\cr
\url{https://www.faa.gov/}\cr
\cr
GHCND: Global Historical Climatology Network - Daily \cr
\url{https://www.ncdc.noaa.gov/data-access/land-based-station-data/land-based-datasets/global-historical-climatology-network-ghcn}\cr
\cr
GHCNMLT: Global Historical Climatology Network - Monthly Land Temperature v4  \cr
\url{https://www.ncdc.noaa.gov/ghcnm/}\cr
\cr
ICAO: International Civil Aviation Organization\cr
\url{http://www.icao.int/Pages/default.aspx}\cr
\cr
MDN: Mercury Deposition Network\cr
\url{http://nadp.sws.uiuc.edu/MDN/}\cr
\cr
MPRC: Manual Precipitation Network\cr
\cr
MSNT: Non-Telemetered Snow Telemetry Network \cr
\cr
NCDCSTNID: National Climatic Data Center\cr
\url{https://www.ncdc.noaa.gov/homr/}\cr
\cr
NEON: National Ecological Observatory Network \cr
\url{http://www.neonscience.org/science-design/field-sites}\cr
\cr
NWSLI: National Weather Service Location Identifer\cr
\url{https://www.weather.gov/arh/stationlist}\cr
\cr
NTN: National Trends Network\cr
\url{http://nadp.sws.uiuc.edu/NTN/}\cr
\cr
OTHER: Telemetered Natural Resource Conservation Service (NRCS) Stations that do not meet criteria for SNOTEL, SNOLITE, SCAN, or NRCS Experimental hydromet\cr
\cr
SCAN: Soil Climate Analysis Network \cr
\url{https://www.wcc.nrcs.usda.gov/about/mon_scan.html} \cr
\cr
SNOW: Snow Course and Aerial Marker Network \cr
\url{https://www.wcc.nrcs.usda.gov/about/mon_manual.html} \cr
\cr
SNTL: Snow Telemetry Network \cr
\url{https://www.wcc.nrcs.usda.gov/about/mon_automate.html}\cr
\cr
SNTLT: Snow Telemetry Network, Limited Sensors \cr
\url{https://www.wcc.nrcs.usda.gov/about/mon_automate.html}\cr
\cr
TRANS: *miscellaneous IDs that do not fall into National Centers for Environmental Information(NCEI) support\cr
\url{https://www.ncei.noaa.gov/}\cr
\cr
USGS: Streamflow Network (United States Geological Survey) \cr
\url{https://water.usgs.gov/nsip/} \cr
\cr
WBAN: Weather Bureau Army Navy \cr
\url{http://rredc.nrel.gov/solar//old_data/nsrdb/1961-1990/hourly/1990/WBANls.html}\cr
\cr
WMO: World Meteorological Organization\cr
\url{https://www.wmo.int/pages/index_en.html}\cr
\cr}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata of environmental monitoring stations having identifier types specified in \code{id}\cr
}
\description{
Return metadata of environmental monitoring stations that have specific identifier types.
}
\examples{
\dontrun{
#return a list of sites that have an WBAN identifer
  getId(id="WBAN")
#return a list of sites that have either an FAA, ICAO, or NWSLI identifer
  getId(id=c("FAA","ICAO","NWSLI"))}
}
\references{
see reference links above
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapSiteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
}
\keyword{COOP,}
\keyword{FAA,}
\keyword{GHCND,}
\keyword{GHCNMLT,}
\keyword{ICAO,}
\keyword{NCDCSTNID,}
\keyword{NEON,}
\keyword{NRCS}
\keyword{NWSLI,}
\keyword{TRANS,}
\keyword{WBAN,}
\keyword{WMO,}
\keyword{air}
\keyword{air,}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{canopy,}
\keyword{chemical,}
\keyword{climate,}
\keyword{cloud,}
\keyword{conductivity,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{flux,}
\keyword{groundwater,}
\keyword{humidity,}
\keyword{in-situ,}
\keyword{lake,}
\keyword{metadata,}
\keyword{phenology,}
\keyword{pollution,}
\keyword{precipitation,}
\keyword{radiation,}
\keyword{reservoir,}
\keyword{river,}
\keyword{salinity,}
\keyword{snow,}
\keyword{soil,}
\keyword{soils,}
\keyword{stream,}
\keyword{temperature,}
\keyword{vapor,}
\keyword{water,}
\keyword{weather,}
\keyword{wind,}
