% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSMNData.R
\name{GetSMNData}
\alias{GetSMNData}
\title{Get Meteorological data}
\source{
https://ssl.smn.gob.ar/dpd/pron5d-calendario.php
}
\usage{
GetSMNData(date, type = c("hourly", "daily", "radiation"), bar = FALSE,
  cache = TRUE, file.dir = tempdir())
}
\arguments{
\item{date}{date vector of dates to fetch data}

\item{type}{type of data to retrieve}

\item{bar}{logical object indicating whether to show a progress bar}

\item{cache}{logical indicating if the results should be saved on disk}

\item{file.dir}{optional directory where to save and/or retrieve data}
}
\value{
For \code{type = "hourly"}, a data.frame with observations of
\describe{
\item{date}{date}
\item{t}{temperature in degrees celsius}
\item{rh}{relative humidity in \%}
\item{slp}{sea level pressure in hPa}
\item{dir}{wind direction in clockwise degrees from 6 o'clock}
\item{V}{wind magnitude in m/s}
\item{station}{station name}
}

For \code{type = "daily"}, a data.frame with observations of
\describe{
\item{date}{date}
\item{tmax}{maximum daily temperature in degrees celsius}
\item{tmin}{minimum daily temperature in degrees celsius}
\item{station}{station name}
}

For \code{type = "radiation"}, a data.frame with observations of
\describe{
\item{date}{date}
\item{global}{global radiation in W/m^2}
\item{diffuse}{diffuse radiation in W/m^2}
\item{station}{station name}
}
}
\description{
Downloads minimum and maximum temperature station data from
Argentina's National Weather Service's public access. Data availability is not
guaranteed so you are encouraged to check it on
\href{https://www.smn.gob.ar/descarga-de-datos}{the website}.
}
\examples{
\dontrun{
dates <- seq.Date(lubridate::today() - 30, lubridate::today(), by = "1 day")
data <- GetSMNData(dates, type = "daily", bar = TRUE)

library(ggplot2)
ggplot(subset(data, station == "BASE BELGRANO II"),
       aes(date, (tmax + tmin)/2)) +
    geom_line()
}

}
