% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{ELT-class}
\alias{ELT-class}
\alias{ELT}
\title{\linkS4class{ELT} class}
\description{
S4 class for empirical likelihood test.
}
\section{Slots}{

\describe{
\item{\code{optim}}{A list of the following optimization results:
\itemize{
\item \code{par} A numeric vector of the solution to the (constrained) optimization
problem.
\item \code{lambda} A numeric vector of the Lagrange multipliers of the dual
problem corresponding to \code{par}.
\item \code{iterations} A single integer for the number of iterations performed.
\item \code{convergence} A single logical for the convergence status.
\item \code{cstr} A single logical for whether constrained EL optimization is
performed or not.
}}

\item{\code{logp}}{A numeric vector of the log probabilities of the (constrained)
empirical likelihood.}

\item{\code{logl}}{A single numeric of the (constrained) empirical log-likelihood.}

\item{\code{loglr}}{A single numeric of the (constrained) empirical log-likelihood
ratio.}

\item{\code{statistic}}{A single numeric of minus twice the (constrained) empirical
log-likelihood ratio with an asymptotic chi-square distribution.}

\item{\code{df}}{A single integer for the chi-square degrees of freedom of the
statistic.}

\item{\code{pval}}{A single numeric for the (calibrated) \eqn{p}-value of the
statistic.}

\item{\code{cv}}{A single numeric for the critical value.}

\item{\code{rhs}}{A numeric vector for the right-hand side of the hypothesis.}

\item{\code{lhs}}{A numeric matrix for the left-hand side of the hypothesis.}

\item{\code{alpha}}{A single numeric for the significance level.}

\item{\code{calibrate}}{A single character for the calibration method used.}

\item{\code{control}}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}}

\examples{
showClass("ELT")
}
