% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_api.R
\name{mx_api_doi}
\alias{mx_api_doi}
\title{Access data on a single medRxiv/bioRxiv record via the Cold Spring Harbour
Laboratory API}
\usage{
mx_api_doi(doi, server = "medrxiv", clean = TRUE)
}
\arguments{
\item{doi}{Digital object identifier of the preprint you wish to retrieve
data on.}

\item{server}{Specify the server you wish to use: "medrxiv" (default) or
"biorxiv"}

\item{clean}{Logical, defaulting to TRUE, indicating whether to clean the
data returned by the API. If TRUE, variables containing absolute paths to
the preprints web-page ("link_page") and PDF ("link_pdf") are generated
from the "server", "DOI", and "version" variables returned by the API. The
"title", "abstract" and "authors" variables are converted to title case.
Finally, the "type" and "server" variables are dropped.}
}
\value{
Dataframe containing details on the preprint identified by the DOI.
}
\description{
Provides programmatic access to data on a single preprint
  identified by a unique Digital Object Identifier (DOI).
}
\examples{
if(interactive()){
mx_data <- mx_api_doi("10.1101/2020.02.25.20021568")
}
}
\seealso{
Other data-source: 
\code{\link{mx_api_content}()},
\code{\link{mx_snapshot}()}
}
\concept{data-source}
