% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/neModel.R
\name{weights.expData}
\alias{weights.expData}
\title{Extract regression weights from the expanded dataset}
\usage{
\method{weights}{expData}(object, ...)
}
\arguments{
\item{object}{an expanded dataset (of class \code{"\link{expData}"}).}

\item{...}{additional arguments.}
}
\value{
a vector of length \code{nrow(object)}, containing the regression weights for the expanded dataset specified in \code{object}.
}
\description{
This function extracts the regression weights (to be used in the natural effect model) for each observation of an expanded dataset.
}
\examples{
data(UPBdata)

weightData <- neWeight(negaff ~ att + gender + educ + age,
                       data = UPBdata, nRep = 2)
head(weights(weightData))
}
\seealso{
\code{\link{coef}}, \code{\link{confint}}, \code{\link{expData}}, \code{\link{neWeight}}, \code{\link{summary}}, \code{\link{vcov}}, \code{\link{weights}}
}

