% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_rock.R
\name{optimization_rock}
\alias{optimization_rock}
\title{Rock optimization}
\usage{
optimization_rock(
  sf,
  SpParams,
  meteo = NULL,
  local_control = defaultControl(),
  dates = NULL,
  parallelize = FALSE,
  num_cores = detectCores() - 1,
  chunk_size = NULL,
  PLCquantile = 0.9,
  qPLC_target = 12,
  qPLC_tol = 0.5,
  sew_min = 30,
  max_rocks = 99,
  progress = TRUE
)
}
\arguments{
\item{sf}{An object of class \code{\link[sf]{sf}} (see \code{\link{spwb_spatial}}).}

\item{SpParams}{A data frame with species parameters (see \code{\link[medfate]{SpParamsMED}}).}

\item{meteo}{Input meteorological data (see section details in \code{\link{spwb_spatial}}).}

\item{local_control}{A list of control parameters (see \code{\link[medfate]{defaultControl}}).}

\item{dates}{A \code{\link{Date}} object describing the days of the period to be modeled.}

\item{parallelize}{Boolean flag to try parallelization (will use all clusters minus one).}

\item{num_cores}{Integer with the number of cores to be used for parallel computation.}

\item{chunk_size}{Integer indicating the size of chuncks to be sent to different processes (by default, the number of spatial elements divided by the number of cores).}

\item{PLCquantile}{Maximum PLC quantile to be calculated across years.}

\item{qPLC_target}{Target PLC to be achieved (by default 12\%).}

\item{qPLC_tol}{Tolerance of PLC difference to target accepted when finding solution.}

\item{sew_min}{Minimum soil extractable water (mm) for rock exploration.}

\item{max_rocks}{Maximum content in coarse fragments allowed for any soil layer.}

\item{progress}{Boolean flag to display progress information of simulations.}
}
\value{
An object of class \code{\link[sf]{sf}} with a modified \code{soil} column and an additional column
\code{optimization_message} with text information about the optimization.
}
\description{
Optimization of rock fragment content
}
\examples{
\donttest{
data("example_ifn")
data("examplemeteo")
data("SpParamsMED")
example_subset <- example_ifn[31:32, ]
optimization_rock(example_subset, SpParamsMED, examplemeteo)
}
}
\seealso{
\code{\link[medfate]{utils_rockOptimization}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
