% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.forest.R
\name{summary.forest}
\alias{summary.forest}
\alias{print.summary.forest}
\title{Summary of forest structure}
\usage{
\method{summary}{forest}(object, SpParams, ...)

\method{print}{summary.forest}(x, digits = getOption("digits"), ...)
}
\arguments{
\item{object}{An object of class \code{\link{forest}}}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}

\item{...}{Additional parameters for functions \code{\link{summary}} and \code{\link{print}}.}

\item{x}{The object returned by \code{summary.forest}.}

\item{digits}{Minimal number of significant digits.}
}
\value{
Function \code{summary.forest} returns a list with several structural attributes, such as the basal area and LAI of the forest.
}
\description{
Displays a summary of forest structure
}
\details{
Function \code{summary.forest} can be used to summarize a \code{forest} object in the console.
}
\examples{
# Summary of example forest
summary(exampleforest, SpParamsMED)

}
\seealso{
\code{\link{forest}}, \code{\link{forest_mapWoodyTables}},  \code{\link{forest_mergeTrees}},  
\code{\link{plot.forest}}, \code{\link{tree2forest}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
