\encoding{UTF-8}
\name{Vertical profiles}
\alias{vprofile.LeafAreaDensity}
\alias{vprofile.FuelBulkDensity}
\alias{vprofile.PARExtinction}
\alias{vprofile.SWRExtinction}
\alias{vprofile.WindExtinction}
\title{
Vertical profiles
}
\description{
Functions to generate vertical profiles generated by an input \code{\link{forest}} object.
}
\usage{
vprofile.LeafAreaDensity(x, SpParams, z = NULL, gdd = NA, draw = TRUE)
vprofile.FuelBulkDensity(x, SpParams, z = NULL, gdd = NA, draw = TRUE)
vprofile.PARExtinction(x, SpParams, z = NULL, gdd = NA, draw = TRUE)
vprofile.SWRExtinction(x, SpParams, z = NULL, gdd = NA, draw = TRUE)
vprofile.WindExtinction(x, SpParams, wind20H, z = NULL,  gdd = NA, draw = TRUE)
}
\arguments{
  \item{x}{An object of class \code{\link{forest}}}
  \item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}
  \item{z}{A numeric vector with height values.}
  \item{gdd}{Growth degree days.}
  \item{wind20H}{The value of measured wind speed at 6 m = 20ft (in m/s).}
  \item{draw}{A logical flag to indicate that a plot is desired.}
}
\value{ A numeric vector with values measured at each height. Units depend on the profile function:
\itemize{
\item{\code{vprofile.LeafAreaDensity}: Cumulative LAI (m2/m2) per height bin.}
\item{\code{vprofile.FuelBulkDensity}: Fuel bulk density (kg/m3) per height bin.}
\item{\code{vprofile.PARExtinction}: Percent of photosynthetically active radiation (\%) corresponding to each height.}
\item{\code{vprofile.SWRExtinction}: Percent of shortwave radiation (\%) corresponding to each height.}
\item{\code{vprofile.WindExtinction}: Wind speed (m/s) corresponding to each height.}
}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, Centre Tecnologic Forestal de Catalunya
}
\seealso{
\code{\link{forest}}
}
\examples{
#Default species parameterization
data(SpParamsMED)

#Load example plot plant data
data(exampleforest)

vprofile.LeafAreaDensity(exampleforest, SpParamsMED)
vprofile.FuelBulkDensity(exampleforest, SpParamsMED)

vprofile.PARExtinction(exampleforest, SpParamsMED)
vprofile.SWRExtinction(exampleforest, SpParamsMED)

vprofile.WindExtinction(exampleforest, SpParamsMED, 20)

}
