% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaturn.R
\name{betaturn}
\alias{betaturn}
\title{Analyze the 'turnover' of microbial communities.}
\description{
Analyze the 'turnover' of microbial communities, i.e. beta-diversity along a gradient <doi:10.1111/j.1461-0248.2010.01552.x>.
The workflow consists of the steps of dissimilarity matrix generation, matrix conversion, differential test and visualization.
}
\examples{

## ------------------------------------------------
## Method `betaturn$new`
## ------------------------------------------------

data(wheat_16S)
b1 <- betaturn$new(wheat_16S, measure = "bray")

## ------------------------------------------------
## Method `betaturn$cal_group_distance`
## ------------------------------------------------

b1$cal_group_distance(group = "Type", within_group = FALSE, by_group = "Plant_ID")

## ------------------------------------------------
## Method `betaturn$cal_group_distance_diff`
## ------------------------------------------------

b1$cal_group_distance_diff(method = "wilcox")

## ------------------------------------------------
## Method `betaturn$plot_group_distance`
## ------------------------------------------------

b1$plot_group_distance()
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-betaturn-new}{\code{betaturn$new()}}
\item \href{#method-betaturn-cal_group_distance}{\code{betaturn$cal_group_distance()}}
\item \href{#method-betaturn-cal_group_distance_diff}{\code{betaturn$cal_group_distance_diff()}}
\item \href{#method-betaturn-plot_group_distance}{\code{betaturn$plot_group_distance()}}
\item \href{#method-betaturn-clone}{\code{betaturn$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-betaturn-new"></a>}}
\if{latex}{\out{\hypertarget{method-betaturn-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{betaturn$new(
  dataset,
  measure = "bray",
  filter_thres = 0,
  abundance.weighted = TRUE,
  null.model = NULL,
  runs = 1000,
  iterations = 1000,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} class.}

\item{\code{measure}}{default "bray"; beta diversity dissimilarity metric; 
must be one of \code{c("bray", "jaccard", "wei_unifrac", "unwei_unifrac", "betaMPD", "betaMNTD", "betaNRI", "betaNTI", "ses_UniFrac", "RCbray")}
or other options in parameter \code{method} of \code{vegan::vegdist} function.
If the distance matrix has been in the beta_diversity list of microtable object, 
the function can ignore this step. Otherwise, the function can generate the corresponding beta diversity distance matrix in the microtable object.
bray: Bray-Curtis; RCbray: Raup–Crick based Bray-Curtis; wei_unifrac: weighted UniFrac; ses_UniFrac: standardized deviation of UniFrac.}

\item{\code{filter_thres}}{default 0; the relative abundance threshold used to filter features with low abundance.}

\item{\code{abundance.weighted}}{default TRUE; whether use abundance-weighted method for the phylogenetic metrics.}

\item{\code{null.model}}{default NULL; one of \code{c("taxa.labels", "richness", "frequency", "sample.pool", "phylogeny.pool", "independentswap", "trialswap")},
in which "taxa.labels" can only be used for phylogenetic analysis. 
See \code{null.model} parameter of \code{ses.mntd} function in \code{picante} package for the algorithm details.}

\item{\code{runs}}{default 1000; simulation number of times for null model.}

\item{\code{iterations}}{default 1000; iteration number for part null models to perform; see iterations parameter of \code{picante::randomizeMatrix} function.}

\item{\code{...}}{parameters passed to \code{cal_betadiv} function of \code{microtable} class when provided measure is not in the current vector;
parameters passed to \code{cal_betamntd} function of \code{trans_nullmodel} class when \code{measure = "betaMNTD"};
parameters passed to \code{cal_ses_betamntd} function of \code{trans_nullmodel} class when \code{measure = "betaNTI"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{dataset}, stored in the object. The new dataset has a beta_diversity list and the calculated distance matrix in the list.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(wheat_16S)
b1 <- betaturn$new(wheat_16S, measure = "bray")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-betaturn-cal_group_distance"></a>}}
\if{latex}{\out{\hypertarget{method-betaturn-cal_group_distance}{}}}
\subsection{Method \code{cal_group_distance()}}{
Convert sample distances within groups or between groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{betaturn$cal_group_distance(
  group,
  within_group = TRUE,
  by_group = NULL,
  ordered_group = NULL,
  sep = " vs ",
  add_cols = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{one colname of sample_table in \code{microtable} object used for group distance convertion.}

\item{\code{within_group}}{default TRUE; whether transform sample distance within groups? If FALSE, transform sample distances between any two groups.}

\item{\code{by_group}}{default NULL; one colname of sample_table in \code{microtable} object.
If provided, convert distances according to the provided by_group parameter. This is especially useful for ordering and filtering values further.
When \code{within_group = TRUE}, the result of by_group parameter is the format of paired groups.
When \code{within_group = FALSE}, the result of by_group parameter is the format same with the group information in \code{sample_table}.}

\item{\code{ordered_group}}{default NULL; a vector representing the ordered elements of \code{group} parameter; only useful when within_group = FALSE.}

\item{\code{sep}}{default TRUE; a character string to separate the group names after merging them into a new name.}

\item{\code{add_cols}}{default NULL; add several columns of sample_table to the final \code{res_group_distance} table according to the \code{by_group} column; 
invoked only when \code{within_group = FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_group_distance} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{b1$cal_group_distance(group = "Type", within_group = FALSE, by_group = "Plant_ID")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-betaturn-cal_group_distance_diff"></a>}}
\if{latex}{\out{\hypertarget{method-betaturn-cal_group_distance_diff}{}}}
\subsection{Method \code{cal_group_distance_diff()}}{
Differential test of distances among groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{betaturn$cal_group_distance_diff(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to \code{cal_group_distance_diff} function of \code{\link{trans_beta}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_group_distance_diff} stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{b1$cal_group_distance_diff(method = "wilcox")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-betaturn-plot_group_distance"></a>}}
\if{latex}{\out{\hypertarget{method-betaturn-plot_group_distance}{}}}
\subsection{Method \code{plot_group_distance()}}{
Plot the distance between samples within or between groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{betaturn$plot_group_distance(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to \code{plot_group_distance} function of \code{\link{trans_beta}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{b1$plot_group_distance()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-betaturn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-betaturn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{betaturn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
