% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_binaryclass.R
\name{GMEAN}
\alias{GMEAN}
\title{G-mean}
\usage{
GMEAN(truth, response, negative, positive)
}
\arguments{
\item{truth}{vector of true values}

\item{response}{vector of predicted values}

\item{negative}{negative class}

\item{positive}{positive class}
}
\description{
Geometric mean of recall and specificity.
}
\examples{
n = 20
set.seed(125)
truth = as.factor(sample(c(1,0), n, replace = TRUE))
probabilities = runif(n)
response = as.factor(as.numeric(probabilities > 0.5))
positive = 1
negative = 0
GMEAN(truth, response, negative, positive)
}
\references{
He, H. & Garcia, E. A. (2009)
*Learning from Imbalanced Data.*
IEEE Transactions on Knowledge and Data Engineering, vol. 21, no. 9. pp. 1263-1284.
}
