% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMeaslesSchool.R
\name{ModelMeaslesSchool}
\alias{ModelMeaslesSchool}
\alias{epiworld_measlesquarantine}
\alias{ModelMeaslesQuarantine}
\title{Measles model with quarantine}
\usage{
ModelMeaslesSchool(
  n,
  prevalence = 1,
  contact_rate = 15/transmission_rate/prodromal_period,
  transmission_rate = 0.9,
  vax_efficacy = 0.99,
  incubation_period = 12,
  prodromal_period = 4,
  rash_period = 3,
  days_undetected = 2,
  hospitalization_rate = 0.2,
  hospitalization_period = 7,
  prop_vaccinated = 1 - 1/15,
  quarantine_period = 21,
  quarantine_willingness = 1,
  isolation_period = 4,
  ...
)

ModelMeaslesQuarantine(...)
}
\arguments{
\item{n}{Number of agents in the model.}

\item{prevalence}{Initial number of agents with the virus.}

\item{contact_rate}{Average number of contacts per step. Default is set to
match the basic reproductive number (R0) of 15 (see details).}

\item{transmission_rate}{Probability of transmission.}

\item{vax_efficacy}{Probability of vaccine efficacy.}

\item{incubation_period}{Average number of incubation days.}

\item{prodromal_period}{Average number of prodromal days.}

\item{rash_period}{Average number of rash days.}

\item{days_undetected}{Average number of days undetected. Detected cases
are moved to isolation and trigger the quarantine process.}

\item{hospitalization_rate}{Probability of hospitalization.}

\item{hospitalization_period}{Average number of days in hospital.}

\item{prop_vaccinated}{Proportion of the population vaccinated.}

\item{quarantine_period}{Number of days an agent is in quarantine.}

\item{quarantine_willingness}{Probability of accepting quarantine (
see details).}

\item{isolation_period}{Number of days an agent is in isolation.}

\item{...}{Further arguments (not used).}
}
\value{
\itemize{
\item The \code{ModelMeaslesQuarantine} function returns a model of classes \link[epiworldR:epiworld-methods]{epiworldR::epiworld_model} and \code{epiworld_measlesquarantine}.
}
}
\description{
Implements a Susceptible-Exposed-Infectious-Hospitalized-Recovered (SEIHR)
model for Measles within a school. The model includes isolation of
detected cases and optional quarantine of unvaccinated individuals.
}
\details{
This model can be described as a SEIHR model with isolation and quarantine.
The infectious state is divided into prodromal and rash phases. Furthermore,
the quarantine state includes exposed, susceptible, prodromal, and recovered
states.

The model is a perfect mixing model, meaning that all agents are in contact
with each other. The model is designed to simulate the spread of Measles
within a school setting, where the population is assumed to be homogeneous.

The quarantine process is triggered any time that an agent with rash is
detected. The agent is then isolated and all agents who are unvaccinated are
quarantined (if willing). Isolated agents then may be moved out of the
isolation in \code{isolation_period} days. The quarantine willingness parameter
sets the probability of accepting quarantine. If a quarantined agent develops
rash, they are moved to isolation, which triggers a new quarantine process.

The basic reproductive number in Measles is estimated to be about 15.
By default, the contact rate of the model is set so that the R0 matches
15.

When \code{quarantine_period} is set to -1, the model assumes
there is no quarantine process. The same happens with \code{isolation_period}.
Since the quarantine process is triggered by an isolation, then
\code{isolation_period = -1} automatically sets \code{quarantine_period = -1}.
}
\note{
As of version 0.10.0, the parameter \code{vax_improved_recovery} has been removed
and is no longer used (it never had a side effect). Future versions may not
accept it.
}
\section{Model diagram}{

\figure{measlesschool.png}{Measles School Diagram}
}

\examples{
# An in a school with low vaccination
model_measles <- ModelMeaslesQuarantine(
  n = 500,
  prevalence = 1,
  prop_vaccinated = 0.70
)

# Running and printing
run(model_measles, ndays = 100, seed = 1912)
model_measles

plot(model_measles)

}
\references{
Jones, Trahern W, and Katherine Baranowski. 2019. "Measles and Mumps: Old
Diseases, New Outbreaks."

Liu, Fengchen, Wayne T A Enanoria, Jennifer Zipprich, Seth Blumberg,
Kathleen Harriman, Sarah F Ackley, William D Wheaton, Justine L
Allpress, and Travis C Porco. 2015. "The Role of Vaccination Coverage,
Individual Behaviors, and the Public Health Response in the Control of
Measles Epidemics: An Agent-Based Simulation for California." \emph{BMC
Public Health} 15 (1): 447. \doi{10.1186/s12889-015-1766-6}.

"Measles Disease Plan." 2019. Utah Department of Health and Human
Services. \url{https://epi.utah.gov/wp-content/uploads/Measles-disease-plan.pdf}.
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelMeaslesMixing}()},
\code{\link{ModelMeaslesMixingRiskQuarantine}()}

Other measles models: 
\code{\link{ModelMeaslesMixing}()},
\code{\link{ModelMeaslesMixingRiskQuarantine}()}
}
\author{
This model was built as a response to the US Measles outbreak in 2025.
This is a collaboration between the University of Utah (ForeSITE center
grant) and the Utah Department of Health and Human Services.
}
\concept{Models}
\concept{measles models}
\concept{measles-models}
